/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.SettableFuture;
import io.grpc.Server;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.XdsClientWrapperForServerSds;
import io.grpc.xds.XdsServerBuilder;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

@VisibleForTesting
public final class ServerWrapperForXds
extends Server {
    private final Server delegate;
    private final XdsClientWrapperForServerSds xdsClientWrapperForServerSds;
    @Nullable
    XdsServerBuilder.ErrorNotifier errorNotifier;
    @Nullable
    XdsClientWrapperForServerSds.ServerWatcher serverWatcher;
    private AtomicBoolean started = new AtomicBoolean();

    public ServerWrapperForXds(Server delegate, XdsClientWrapperForServerSds xdsClientWrapperForServerSds, @Nullable XdsServerBuilder.ErrorNotifier errorNotifier) {
        this.delegate = (Server)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
        this.xdsClientWrapperForServerSds = (XdsClientWrapperForServerSds)Preconditions.checkNotNull((Object)xdsClientWrapperForServerSds, (Object)"xdsClientWrapperForServerSds");
        this.errorNotifier = errorNotifier;
    }

    public Server start() throws IOException {
        Preconditions.checkState((boolean)this.started.compareAndSet(false, true), (Object)"Already started");
        Future<EnvoyServerProtoData.DownstreamTlsContext> future = this.addServerWatcher();
        if (!this.xdsClientWrapperForServerSds.hasXdsClient()) {
            this.xdsClientWrapperForServerSds.createXdsClientAndStart();
        }
        try {
            future.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            this.removeServerWatcher();
            if (ex instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new RuntimeException(ex);
        }
        this.delegate.start();
        return this;
    }

    private Future<EnvoyServerProtoData.DownstreamTlsContext> addServerWatcher() {
        final SettableFuture settableFuture = SettableFuture.create();
        this.serverWatcher = new XdsClientWrapperForServerSds.ServerWatcher(){

            @Override
            public void onError(Status error) {
                if (ServerWrapperForXds.this.errorNotifier != null) {
                    ServerWrapperForXds.this.errorNotifier.onError(error);
                }
            }

            @Override
            public void onSuccess(EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext) {
                ServerWrapperForXds.this.removeServerWatcher();
                settableFuture.set((Object)downstreamTlsContext);
            }
        };
        this.xdsClientWrapperForServerSds.addServerWatcher(this.serverWatcher);
        return settableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeServerWatcher() {
        XdsClientWrapperForServerSds xdsClientWrapperForServerSds = this.xdsClientWrapperForServerSds;
        synchronized (xdsClientWrapperForServerSds) {
            if (this.serverWatcher != null) {
                this.xdsClientWrapperForServerSds.removeServerWatcher(this.serverWatcher);
                this.serverWatcher = null;
            }
        }
    }

    public Server shutdown() {
        this.delegate.shutdown();
        this.xdsClientWrapperForServerSds.shutdown();
        return this;
    }

    public Server shutdownNow() {
        this.delegate.shutdownNow();
        this.xdsClientWrapperForServerSds.shutdown();
        return this;
    }

    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    public void awaitTermination() throws InterruptedException {
        this.delegate.awaitTermination();
    }

    public int getPort() {
        return this.delegate.getPort();
    }

    public List<? extends SocketAddress> getListenSockets() {
        return this.delegate.getListenSockets();
    }

    public List<ServerServiceDefinition> getServices() {
        return this.delegate.getServices();
    }

    public List<ServerServiceDefinition> getImmutableServices() {
        return this.delegate.getImmutableServices();
    }

    public List<ServerServiceDefinition> getMutableServices() {
        return this.delegate.getMutableServices();
    }
}

