/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.DefaultProfile;
import de.iip_ecosphere.platform.support.LifecycleDescriptor;
import de.iip_ecosphere.platform.support.LifecycleExclude;
import de.iip_ecosphere.platform.support.LifecycleProfile;
import de.iip_ecosphere.platform.support.PidFile;
import de.iip_ecosphere.platform.support.PidLifecycleDescriptor;
import de.iip_ecosphere.platform.support.TerminatingLifecycleDescriptor;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.plugins.CurrentClassloaderPluginSetupDescriptor;
import de.iip_ecosphere.platform.support.plugins.PluginManager;
import de.iip_ecosphere.platform.support.plugins.PluginSetupDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class LifecycleHandler {
    public static final String MSG_STARTUP_COMPLETED = "Startup completed.";
    private static final String CMD_ARG = "--iip.profile=";
    private static String[] cmdArgs;
    private static boolean waiting;
    private static List<LifecycleDescriptor> descriptors;
    private static LifecycleProfile profile;

    public static void startup(String[] args) {
        PluginManager.registerPlugin((PluginSetupDescriptor)CurrentClassloaderPluginSetupDescriptor.INSTANCE);
        cmdArgs = (String[])args.clone();
        AtomicReference pidFile = new AtomicReference();
        profile = DefaultProfile.INSTANCE;
        String profileName = "default";
        for (int a = 0; a < args.length; ++a) {
            if (!args[a].startsWith(CMD_ARG)) continue;
            profileName = args[a].substring(CMD_ARG.length());
            break;
        }
        if (!profileName.equals("default")) {
            for (LifecycleProfile p : ServiceLoader.load(LifecycleProfile.class)) {
                if (!profileName.equals(p.getName())) continue;
                profile = p;
                break;
            }
        }
        profile.initialize(args);
        LifecycleHandler.forEach(l -> {
            if (profile.test(l.getClass())) {
                try {
                    LoggerFactory.getLogger(LifecycleHandler.class).info("Starting {} ({}) in profile {}", new Object[]{l.getClass().getName(), l.priority(), profile.getName()});
                    l.startup(args);
                    if (l instanceof PidLifecycleDescriptor && null == pidFile.get()) {
                        pidFile.set(((PidLifecycleDescriptor)l).getPidFileName());
                    }
                }
                catch (Throwable t) {
                    LoggerFactory.getLogger(LifecycleHandler.class).error("Startup failure in " + l.getClass().getName() + " with " + t.getMessage(), t);
                }
            }
        }, false);
        String pidFileName = (String)pidFile.get();
        if (null != pidFileName) {
            try {
                PidFile.createInDefaultDir((String)pidFileName, (boolean)true);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(LifecycleHandler.class).warn("Cannot create PID file " + pidFileName + ": " + e.getMessage());
            }
        }
        String add = "";
        if (waiting) {
            add = " Running until Ctrl-C.";
        }
        LoggerFactory.getLogger(LifecycleHandler.class).info("{}{}", (Object)MSG_STARTUP_COMPLETED, (Object)add);
    }

    public static void shutdown() {
        LifecycleHandler.forEach(l -> {
            if (profile.test(l.getClass())) {
                try {
                    LoggerFactory.getLogger(LifecycleHandler.class).info("Stopping {} ({})", (Object)l.getClass().getName(), (Object)l.priority());
                    l.shutdown();
                }
                catch (Throwable t) {
                    LoggerFactory.getLogger(LifecycleHandler.class).error("Shutdown failure in " + l.getClass().getName() + " with " + t.getMessage(), t);
                }
            }
        }, true);
    }

    public static void attachShutdownHooks() {
        LifecycleHandler.forEach(l -> {
            Thread t = l.getShutdownHook();
            if (null != t) {
                Runtime.getRuntime().addShutdownHook(t);
            }
        }, true);
    }

    private static void forEach(Consumer<LifecycleDescriptor> consumer, boolean revert) {
        ArrayList<LifecycleDescriptor> desc = new ArrayList<LifecycleDescriptor>(LifecycleHandler.getDescriptors());
        HashSet<String> excluded = new HashSet<String>();
        for (LifecycleDescriptor d : desc) {
            LifecycleExclude exclude = d.getClass().getAnnotation(LifecycleExclude.class);
            if (null == exclude) continue;
            for (Class<?> c : exclude.value()) {
                excluded.add(c.getName());
            }
        }
        int factor = revert ? -1 : 1;
        Collections.sort(desc, (d1, d2) -> factor * Integer.compare(d1.priority(), d2.priority()));
        for (LifecycleDescriptor d : desc) {
            if (excluded.contains(d.getClass().getName())) continue;
            consumer.accept(d);
        }
    }

    private static List<LifecycleDescriptor> getDescriptors() {
        if (null == descriptors) {
            descriptors = CollectionUtils.toList(ServiceLoader.load(LifecycleDescriptor.class).iterator());
        }
        return descriptors;
    }

    public static boolean continueWaiting() {
        boolean cont = true;
        List<LifecycleDescriptor> desc = LifecycleHandler.getDescriptors();
        for (int l = 0; cont && l < desc.size(); ++l) {
            LifecycleDescriptor d = desc.get(l);
            if (!(d instanceof TerminatingLifecycleDescriptor)) continue;
            cont = ((TerminatingLifecycleDescriptor)d).continueWaiting();
        }
        return cont;
    }

    public static void waitUntilEnd(String[] args) {
        LifecycleHandler.waitUntilEnd(args, true);
    }

    public static void waitUntilEnd(String[] args, boolean shutdownAsHook) {
        waiting = true;
        LifecycleHandler.attachShutdownHooks();
        if (shutdownAsHook) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> LifecycleHandler.shutdown()));
        }
        LifecycleHandler.startup(args);
        while (LifecycleHandler.continueWaiting()) {
            TimeUtils.sleep((int)500);
        }
        if (!shutdownAsHook) {
            LifecycleHandler.shutdown();
        }
    }

    public static List<LifecycleDescriptor> descriptors() {
        return Collections.unmodifiableList(LifecycleHandler.getDescriptors());
    }

    public static <L extends LifecycleDescriptor> Optional<L> getAnyDescriptor(Class<L> cls) {
        return LifecycleHandler.descriptors().stream().filter(d -> cls.isInstance(d)).map(d -> (LifecycleDescriptor)cls.cast(d)).findAny();
    }

    public static String[] getCmdArgs() {
        return null == cmdArgs ? null : (String[])cmdArgs.clone();
    }

    static {
        waiting = false;
        profile = DefaultProfile.INSTANCE;
    }

    public static class WaitingStarterWithShutdown {
        public static void main(String[] args) {
            LifecycleHandler.waitUntilEnd(args, false);
        }
    }

    public static class WaitingStarter {
        public static void main(String[] args) {
            LifecycleHandler.waitUntilEnd(args);
        }
    }

    public static class OneShotStarter {
        public static void main(String[] args) {
            LifecycleHandler.attachShutdownHooks();
            LifecycleHandler.startup(args);
            LifecycleHandler.shutdown();
        }
    }
}

