/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.re2j.Pattern;
import io.grpc.xds.AutoValue_Matchers_FractionMatcher;
import io.grpc.xds.AutoValue_Matchers_HeaderMatcher;
import io.grpc.xds.AutoValue_Matchers_HeaderMatcher_Range;
import io.grpc.xds.AutoValue_Matchers_PathMatcher;
import javax.annotation.Nullable;

final class Matchers {
    private Matchers() {
    }

    @AutoValue
    static abstract class FractionMatcher {
        FractionMatcher() {
        }

        abstract int numerator();

        abstract int denominator();

        static FractionMatcher create(int numerator, int denominator) {
            return new AutoValue_Matchers_FractionMatcher(numerator, denominator);
        }
    }

    @AutoValue
    static abstract class HeaderMatcher {
        HeaderMatcher() {
        }

        abstract String name();

        @Nullable
        abstract String exactValue();

        @Nullable
        abstract Pattern safeRegEx();

        @Nullable
        abstract Range range();

        @Nullable
        abstract Boolean present();

        @Nullable
        abstract String prefix();

        @Nullable
        abstract String suffix();

        abstract boolean inverted();

        static HeaderMatcher forExactValue(String name, String exactValue, boolean inverted) {
            Preconditions.checkNotNull((Object)name, (Object)"name");
            Preconditions.checkNotNull((Object)exactValue, (Object)"exactValue");
            return HeaderMatcher.create(name, exactValue, null, null, null, null, null, inverted);
        }

        static HeaderMatcher forSafeRegEx(String name, Pattern safeRegEx, boolean inverted) {
            Preconditions.checkNotNull((Object)name, (Object)"name");
            Preconditions.checkNotNull((Object)safeRegEx, (Object)"safeRegEx");
            return HeaderMatcher.create(name, null, safeRegEx, null, null, null, null, inverted);
        }

        static HeaderMatcher forRange(String name, Range range, boolean inverted) {
            Preconditions.checkNotNull((Object)name, (Object)"name");
            Preconditions.checkNotNull((Object)range, (Object)"range");
            return HeaderMatcher.create(name, null, null, range, null, null, null, inverted);
        }

        static HeaderMatcher forPresent(String name, boolean present, boolean inverted) {
            Preconditions.checkNotNull((Object)name, (Object)"name");
            return HeaderMatcher.create(name, null, null, null, present, null, null, inverted);
        }

        static HeaderMatcher forPrefix(String name, String prefix, boolean inverted) {
            Preconditions.checkNotNull((Object)name, (Object)"name");
            Preconditions.checkNotNull((Object)prefix, (Object)"prefix");
            return HeaderMatcher.create(name, null, null, null, null, prefix, null, inverted);
        }

        static HeaderMatcher forSuffix(String name, String suffix, boolean inverted) {
            Preconditions.checkNotNull((Object)name, (Object)"name");
            Preconditions.checkNotNull((Object)suffix, (Object)"suffix");
            return HeaderMatcher.create(name, null, null, null, null, null, suffix, inverted);
        }

        private static HeaderMatcher create(String name, @Nullable String exactValue, @Nullable Pattern safeRegEx, @Nullable Range range, @Nullable Boolean present, @Nullable String prefix, @Nullable String suffix, boolean inverted) {
            Preconditions.checkNotNull((Object)name, (Object)"name");
            return new AutoValue_Matchers_HeaderMatcher(name, exactValue, safeRegEx, range, present, prefix, suffix, inverted);
        }

        @AutoValue
        static abstract class Range {
            Range() {
            }

            abstract long start();

            abstract long end();

            static Range create(long start, long end) {
                return new AutoValue_Matchers_HeaderMatcher_Range(start, end);
            }
        }
    }

    @AutoValue
    static abstract class PathMatcher {
        PathMatcher() {
        }

        @Nullable
        abstract String path();

        @Nullable
        abstract String prefix();

        @Nullable
        abstract Pattern regEx();

        abstract boolean caseSensitive();

        static PathMatcher fromPath(String path, boolean caseSensitive) {
            Preconditions.checkNotNull((Object)path, (Object)"path");
            return PathMatcher.create(path, null, null, caseSensitive);
        }

        static PathMatcher fromPrefix(String prefix, boolean caseSensitive) {
            Preconditions.checkNotNull((Object)prefix, (Object)"prefix");
            return PathMatcher.create(null, prefix, null, caseSensitive);
        }

        static PathMatcher fromRegEx(Pattern regEx) {
            Preconditions.checkNotNull((Object)regEx, (Object)"regEx");
            return PathMatcher.create(null, null, regEx, false);
        }

        private static PathMatcher create(@Nullable String path, @Nullable String prefix, @Nullable Pattern regEx, boolean caseSensitive) {
            return new AutoValue_Matchers_PathMatcher(path, prefix, regEx, caseSensitive);
        }
    }
}

