/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.grpc.Status;
import io.grpc.xds.Endpoints;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.HttpFault;
import io.grpc.xds.LoadStatsManager2;
import io.grpc.xds.Locality;
import io.grpc.xds.VirtualHost;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

abstract class XdsClient {
    XdsClient() {
    }

    void shutdown() {
        throw new UnsupportedOperationException();
    }

    boolean isShutDown() {
        throw new UnsupportedOperationException();
    }

    void watchLdsResource(String resourceName, LdsResourceWatcher watcher) {
        throw new UnsupportedOperationException();
    }

    void cancelLdsResourceWatch(String resourceName, LdsResourceWatcher watcher) {
        throw new UnsupportedOperationException();
    }

    void watchRdsResource(String resourceName, RdsResourceWatcher watcher) {
        throw new UnsupportedOperationException();
    }

    void cancelRdsResourceWatch(String resourceName, RdsResourceWatcher watcher) {
        throw new UnsupportedOperationException();
    }

    void watchCdsResource(String resourceName, CdsResourceWatcher watcher) {
        throw new UnsupportedOperationException();
    }

    void cancelCdsResourceWatch(String resourceName, CdsResourceWatcher watcher) {
        throw new UnsupportedOperationException();
    }

    void watchEdsResource(String resourceName, EdsResourceWatcher watcher) {
        throw new UnsupportedOperationException();
    }

    void cancelEdsResourceWatch(String resourceName, EdsResourceWatcher watcher) {
        throw new UnsupportedOperationException();
    }

    void watchListenerData(int port, ListenerWatcher watcher) {
        throw new UnsupportedOperationException();
    }

    LoadStatsManager2.ClusterDropStats addClusterDropStats(String clusterName, @Nullable String edsServiceName) {
        throw new UnsupportedOperationException();
    }

    LoadStatsManager2.ClusterLocalityStats addClusterLocalityStats(String clusterName, @Nullable String edsServiceName, Locality locality) {
        throw new UnsupportedOperationException();
    }

    static interface ListenerWatcher
    extends ResourceWatcher {
        public void onListenerChanged(ListenerUpdate var1);
    }

    static interface EdsResourceWatcher
    extends ResourceWatcher {
        public void onChanged(EdsUpdate var1);
    }

    static interface CdsResourceWatcher
    extends ResourceWatcher {
        public void onChanged(CdsUpdate var1);
    }

    static interface RdsResourceWatcher
    extends ResourceWatcher {
        public void onChanged(RdsUpdate var1);
    }

    static interface LdsResourceWatcher
    extends ResourceWatcher {
        public void onChanged(LdsUpdate var1);
    }

    static interface ResourceWatcher {
        public void onError(Status var1);

        public void onResourceDoesNotExist(String var1);
    }

    static interface ResourceUpdate {
    }

    static final class ListenerUpdate
    implements ResourceUpdate {
        private final EnvoyServerProtoData.Listener listener;

        private ListenerUpdate(EnvoyServerProtoData.Listener listener) {
            this.listener = listener;
        }

        public EnvoyServerProtoData.Listener getListener() {
            return this.listener;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("listener", (Object)this.listener).toString();
        }

        static Builder newBuilder() {
            return new Builder();
        }

        static final class Builder {
            private EnvoyServerProtoData.Listener listener;

            private Builder() {
            }

            Builder setListener(EnvoyServerProtoData.Listener listener) {
                this.listener = listener;
                return this;
            }

            ListenerUpdate build() {
                Preconditions.checkState((this.listener != null ? 1 : 0) != 0, (Object)"listener is not set");
                return new ListenerUpdate(this.listener);
            }
        }
    }

    static final class EdsUpdate
    implements ResourceUpdate {
        final String clusterName;
        final Map<Locality, Endpoints.LocalityLbEndpoints> localityLbEndpointsMap;
        final List<Endpoints.DropOverload> dropPolicies;

        EdsUpdate(String clusterName, Map<Locality, Endpoints.LocalityLbEndpoints> localityLbEndpoints, List<Endpoints.DropOverload> dropPolicies) {
            this.clusterName = (String)Preconditions.checkNotNull((Object)clusterName, (Object)"clusterName");
            this.localityLbEndpointsMap = Collections.unmodifiableMap(new LinkedHashMap((Map)Preconditions.checkNotNull(localityLbEndpoints, (Object)"localityLbEndpoints")));
            this.dropPolicies = Collections.unmodifiableList(new ArrayList((Collection)Preconditions.checkNotNull(dropPolicies, (Object)"dropPolicies")));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EdsUpdate that = (EdsUpdate)o;
            return Objects.equals(this.clusterName, that.clusterName) && Objects.equals(this.localityLbEndpointsMap, that.localityLbEndpointsMap) && Objects.equals(this.dropPolicies, that.dropPolicies);
        }

        public int hashCode() {
            return Objects.hash(this.clusterName, this.localityLbEndpointsMap, this.dropPolicies);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("clusterName", (Object)this.clusterName).add("localityLbEndpointsMap", this.localityLbEndpointsMap).add("dropPolicies", this.dropPolicies).toString();
        }
    }

    static final class CdsUpdate
    implements ResourceUpdate {
        final String clusterName;
        final ClusterType clusterType;
        final ClusterConfig clusterConfig;

        CdsUpdate(String clusterName, ClusterType clusterType, ClusterConfig clusterConfig) {
            this.clusterName = (String)Preconditions.checkNotNull((Object)clusterName, (Object)"clusterName");
            this.clusterType = (ClusterType)((Object)Preconditions.checkNotNull((Object)((Object)clusterType), (Object)"clusterType"));
            this.clusterConfig = (ClusterConfig)Preconditions.checkNotNull((Object)clusterConfig, (Object)"clusterConfig");
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.clusterName, this.clusterType, this.clusterConfig});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CdsUpdate that = (CdsUpdate)o;
            return Objects.equals(this.clusterName, that.clusterName) && Objects.equals((Object)this.clusterType, (Object)that.clusterType) && Objects.equals(this.clusterConfig, that.clusterConfig);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("clusterName", (Object)this.clusterName).add("clusterType", (Object)this.clusterType).add("clusterConfig", (Object)this.clusterConfig).toString();
        }

        static final class LogicalDnsClusterConfig
        extends NonAggregateClusterConfig {
            LogicalDnsClusterConfig(String lbPolicy, @Nullable String lrsServerName, @Nullable Long maxConcurrentRequests, @Nullable EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext) {
                super(lbPolicy, lrsServerName, maxConcurrentRequests, upstreamTlsContext);
            }

            public int hashCode() {
                return Objects.hash(this.lbPolicy, this.lrsServerName, this.maxConcurrentRequests, this.upstreamTlsContext);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                LogicalDnsClusterConfig that = (LogicalDnsClusterConfig)o;
                return Objects.equals(this.lbPolicy, that.lbPolicy) && Objects.equals(this.lrsServerName, that.lrsServerName) && Objects.equals(this.maxConcurrentRequests, that.maxConcurrentRequests) && Objects.equals(this.upstreamTlsContext, that.upstreamTlsContext);
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("lbPolicy", (Object)this.lbPolicy).add("lrsServerName", (Object)this.lrsServerName).add("maxConcurrentRequests", (Object)this.maxConcurrentRequests).toString();
            }
        }

        static final class EdsClusterConfig
        extends NonAggregateClusterConfig {
            @Nullable
            final String edsServiceName;

            EdsClusterConfig(String lbPolicy, @Nullable String edsServiceName, @Nullable String lrsServerName, @Nullable Long maxConcurrentRequests, @Nullable EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext) {
                super(lbPolicy, lrsServerName, maxConcurrentRequests, upstreamTlsContext);
                this.edsServiceName = edsServiceName;
            }

            public int hashCode() {
                return Objects.hash(this.lbPolicy, this.edsServiceName, this.lrsServerName, this.maxConcurrentRequests, this.upstreamTlsContext);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                EdsClusterConfig that = (EdsClusterConfig)o;
                return Objects.equals(this.lbPolicy, that.lbPolicy) && Objects.equals(this.edsServiceName, that.edsServiceName) && Objects.equals(this.lrsServerName, that.lrsServerName) && Objects.equals(this.maxConcurrentRequests, that.maxConcurrentRequests) && Objects.equals(this.upstreamTlsContext, that.upstreamTlsContext);
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("lbPolicy", (Object)this.lbPolicy).add("edsServiceName", (Object)this.edsServiceName).add("lrsServerName", (Object)this.lrsServerName).add("maxConcurrentRequests", (Object)this.maxConcurrentRequests).toString();
            }
        }

        private static abstract class NonAggregateClusterConfig
        extends ClusterConfig {
            @Nullable
            final String lrsServerName;
            @Nullable
            final Long maxConcurrentRequests;
            @Nullable
            final EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext;

            private NonAggregateClusterConfig(String lbPolicy, @Nullable String lrsServerName, @Nullable Long maxConcurrentRequests, @Nullable EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext) {
                super(lbPolicy);
                this.lrsServerName = lrsServerName;
                this.maxConcurrentRequests = maxConcurrentRequests;
                this.upstreamTlsContext = upstreamTlsContext;
            }
        }

        static final class AggregateClusterConfig
        extends ClusterConfig {
            final List<String> prioritizedClusterNames;

            AggregateClusterConfig(String lbPolicy, List<String> prioritizedClusterNames) {
                super(lbPolicy);
                this.prioritizedClusterNames = Collections.unmodifiableList(new ArrayList<String>(prioritizedClusterNames));
            }

            public int hashCode() {
                return Objects.hash(this.lbPolicy, this.prioritizedClusterNames);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                AggregateClusterConfig that = (AggregateClusterConfig)o;
                return Objects.equals(this.lbPolicy, that.lbPolicy) && Objects.equals(this.prioritizedClusterNames, that.prioritizedClusterNames);
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("lbPolicy", (Object)this.lbPolicy).add("prioritizedClusterNames", this.prioritizedClusterNames).toString();
            }
        }

        static abstract class ClusterConfig {
            final String lbPolicy;

            private ClusterConfig(String lbPolicy) {
                this.lbPolicy = (String)Preconditions.checkNotNull((Object)lbPolicy, (Object)"lbPolicy");
            }
        }

        static enum ClusterType {
            EDS,
            LOGICAL_DNS,
            AGGREGATE;

        }
    }

    static final class RdsUpdate
    implements ResourceUpdate {
        final List<VirtualHost> virtualHosts;

        RdsUpdate(List<VirtualHost> virtualHosts) {
            this.virtualHosts = Collections.unmodifiableList(new ArrayList((Collection)Preconditions.checkNotNull(virtualHosts, (Object)"virtualHosts")));
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("virtualHosts", this.virtualHosts).toString();
        }

        public int hashCode() {
            return Objects.hash(this.virtualHosts);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RdsUpdate that = (RdsUpdate)o;
            return Objects.equals(this.virtualHosts, that.virtualHosts);
        }
    }

    static final class LdsUpdate
    implements ResourceUpdate {
        final long httpMaxStreamDurationNano;
        @Nullable
        final String rdsName;
        @Nullable
        final List<VirtualHost> virtualHosts;
        final boolean hasFaultInjection;
        @Nullable
        final HttpFault httpFault;

        LdsUpdate(long httpMaxStreamDurationNano, String rdsName, boolean hasFaultInjection, @Nullable HttpFault httpFault) {
            this(httpMaxStreamDurationNano, rdsName, null, hasFaultInjection, httpFault);
        }

        LdsUpdate(long httpMaxStreamDurationNano, List<VirtualHost> virtualHosts, boolean hasFaultInjection, @Nullable HttpFault httpFault) {
            this(httpMaxStreamDurationNano, null, virtualHosts, hasFaultInjection, httpFault);
        }

        private LdsUpdate(long httpMaxStreamDurationNano, @Nullable String rdsName, @Nullable List<VirtualHost> virtualHosts, boolean hasFaultInjection, @Nullable HttpFault httpFault) {
            this.httpMaxStreamDurationNano = httpMaxStreamDurationNano;
            this.rdsName = rdsName;
            this.virtualHosts = virtualHosts == null ? null : Collections.unmodifiableList(new ArrayList<VirtualHost>(virtualHosts));
            this.hasFaultInjection = hasFaultInjection;
            this.httpFault = httpFault;
        }

        public int hashCode() {
            return Objects.hash(this.httpMaxStreamDurationNano, this.rdsName, this.virtualHosts, this.hasFaultInjection, this.httpFault);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LdsUpdate that = (LdsUpdate)o;
            return this.httpMaxStreamDurationNano == that.httpMaxStreamDurationNano && Objects.equals(this.rdsName, that.rdsName) && Objects.equals(this.virtualHosts, that.virtualHosts) && this.hasFaultInjection == that.hasFaultInjection && Objects.equals(this.httpFault, that.httpFault);
        }

        public String toString() {
            MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this);
            toStringHelper.add("httpMaxStreamDurationNano", this.httpMaxStreamDurationNano);
            if (this.rdsName != null) {
                toStringHelper.add("rdsName", (Object)this.rdsName);
            } else {
                toStringHelper.add("virtualHosts", this.virtualHosts);
            }
            if (this.hasFaultInjection) {
                toStringHelper.add("faultInjectionEnabled", true).add("httpFault", (Object)this.httpFault);
            }
            return toStringHelper.toString();
        }
    }
}

