/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas.types.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EnumRegistry {
    private static final Map<Class<?>, Set<Class<?>>> ENUMS = new HashMap();

    public static <T extends Enum<T>> void registerEnum(Class<T> cls) {
        EnumRegistry.process(cls, cls, true);
    }

    public static <T extends Enum<T>> void unregisterEnum(Class<T> cls) {
        EnumRegistry.process(cls, cls, false);
    }

    private static void process(Class<?> cls, Class<?> reg, boolean add) {
        Set<Class<?>> compatible = ENUMS.get(cls);
        if (add) {
            if (null == compatible) {
                compatible = new HashSet();
                ENUMS.put(cls, compatible);
            }
            compatible.add(reg);
        } else if (null != compatible) {
            compatible.remove(reg);
        }
        for (Class<?> i : cls.getInterfaces()) {
            EnumRegistry.process(i, reg, add);
        }
    }

    public static <T, E extends Enum<E>> Iterable<Class<?>> getEnums(Class<T> cls, Class<E> dflt) {
        Set<Class<?>> result = ENUMS.get(cls);
        if (null == result) {
            result = new HashSet();
            if (cls.isAssignableFrom(dflt)) {
                result.add(dflt);
            }
        } else if (!result.contains(dflt)) {
            result = new HashSet(result);
            if (cls.isAssignableFrom(dflt)) {
                result.add(dflt);
            }
        }
        return result;
    }
}

