/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.metrics.plcnext;

import Arp.Device.Interface.Services.Grpc.IDeviceStatusServiceGrpc;
import Arp.Device.Interface.Services.Grpc.IDeviceStatusServiceOuterClass;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.metrics.SystemMetrics;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.unix.DomainSocketAddress;
import java.io.File;
import java.net.SocketAddress;
import java.util.concurrent.ExecutionException;

public class PlcNextSystemMetrics
implements SystemMetrics {
    public static final SystemMetrics INSTANCE = new PlcNextSystemMetrics();
    public static final String PLCNEXT_SOCK = System.getProperty("iip.devices.plcNext.grpc.sock", "/run/plcnext/grpc.sock");
    private static final long TIMEOUT = 500L;
    private static final IDeviceStatusServiceOuterClass.IDeviceStatusServiceGetItemRequest REQUEST_BOARD_TEMPERATURE = IDeviceStatusServiceOuterClass.IDeviceStatusServiceGetItemRequest.newBuilder().setIdentifier("Status.Board.Temperature.Centigrade").build();
    private static final IDeviceStatusServiceOuterClass.IDeviceStatusServiceGetItemRequest REQUEST_CPU_TEMPERATURE = IDeviceStatusServiceOuterClass.IDeviceStatusServiceGetItemRequest.newBuilder().setIdentifier("Status.Cpu.Temperature.Centigrade").build();
    private IDeviceStatusServiceGrpc.IDeviceStatusServiceBlockingStub client;
    private long lastRequest = -1L;
    private boolean failed = false;
    private ManagedChannel channel;
    private EpollEventLoopGroup eventLoopGroup;
    private float boardTemp = -274.0f;
    private float cpuTemp = -274.0f;

    protected PlcNextSystemMetrics() {
    }

    private void request() {
        if (!(this.failed || this.lastRequest >= 1L && System.currentTimeMillis() - this.lastRequest <= 500L)) {
            if (null == this.channel) {
                File sock = new File(PLCNEXT_SOCK);
                if (sock.exists()) {
                    try {
                        sock.setExecutable(true);
                        sock.setReadable(true);
                        sock.setWritable(true);
                    }
                    catch (SecurityException e) {
                        LoggerFactory.getLogger(PlcNextSystemMetrics.class).error("Cannot set permissions on {}. Access may fail.", (Object)sock);
                    }
                    this.eventLoopGroup = new EpollEventLoopGroup();
                    this.channel = NettyChannelBuilder.forAddress((SocketAddress)new DomainSocketAddress(sock)).eventLoopGroup((EventLoopGroup)this.eventLoopGroup).channelType(EpollDomainSocketChannel.class).usePlaintext().build();
                    this.client = IDeviceStatusServiceGrpc.newBlockingStub((Channel)this.channel);
                } else {
                    LoggerFactory.getLogger(PlcNextSystemMetrics.class).error("Cannot find/open {}. Is your device a Phoenix Contact AXC and your firmware at least 2022.0 LTS", (Object)sock);
                    this.failed = true;
                }
            }
            if (null != this.client) {
                this.boardTemp = this.client.getItem(REQUEST_BOARD_TEMPERATURE).getReturnValue().getInt8Value();
                this.cpuTemp = this.client.getItem(REQUEST_CPU_TEMPERATURE).getReturnValue().getInt8Value();
            }
        }
    }

    public float getCaseTemperature() {
        this.request();
        return this.boardTemp;
    }

    public float getCpuTemperature() {
        this.request();
        return this.cpuTemp;
    }

    public int getNumGpuCores() {
        return 0;
    }

    public int getNumTpuCores() {
        this.request();
        return 0;
    }

    public void close() {
        if (null != this.channel) {
            this.client = null;
            this.channel.shutdownNow();
            try {
                this.eventLoopGroup.shutdownGracefully().get();
            }
            catch (InterruptedException | ExecutionException e) {
                LoggerFactory.getLogger(PlcNextSystemMetrics.class).error("Shutting down: {}", (Object)e.getMessage());
            }
        }
    }
}

