/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.rls;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

final class RlsProtoData {
    RlsProtoData() {
    }

    private static void checkUniqueName(List<GrpcKeyBuilder> grpcKeyBuilders) {
        HashSet<GrpcKeyBuilder.Name> names = new HashSet<GrpcKeyBuilder.Name>();
        for (GrpcKeyBuilder grpcKeyBuilder : grpcKeyBuilders) {
            int prevSize = names.size();
            names.addAll((Collection<GrpcKeyBuilder.Name>)grpcKeyBuilder.getNames());
            if (names.size() == prevSize + grpcKeyBuilder.getNames().size()) continue;
            throw new IllegalStateException("Names in the GrpcKeyBuilders should be unique");
        }
    }

    static final class GrpcKeyBuilder {
        private final ImmutableList<Name> names;
        private final ImmutableList<NameMatcher> headers;

        public GrpcKeyBuilder(List<Name> names, List<NameMatcher> headers) {
            Preconditions.checkState((names != null && !names.isEmpty() ? 1 : 0) != 0, (Object)"names cannot be empty");
            this.names = ImmutableList.copyOf(names);
            GrpcKeyBuilder.checkUniqueKey((List)Preconditions.checkNotNull(headers, (Object)"headers"));
            this.headers = ImmutableList.copyOf(headers);
        }

        private static void checkUniqueKey(List<NameMatcher> headers) {
            HashSet<String> names = new HashSet<String>();
            for (NameMatcher header : headers) {
                Preconditions.checkState((boolean)names.add(header.key), (Object)"key in headers must be unique");
            }
        }

        ImmutableList<Name> getNames() {
            return this.names;
        }

        ImmutableList<NameMatcher> getHeaders() {
            return this.headers;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GrpcKeyBuilder that = (GrpcKeyBuilder)o;
            return com.google.common.base.Objects.equal(this.names, that.names) && com.google.common.base.Objects.equal(this.headers, that.headers);
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.names, this.headers});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("names", this.names).add("headers", this.headers).toString();
        }

        static final class Name {
            private final String service;
            private final String method;

            Name(String service) {
                this(service, "*");
            }

            Name(String service, String method) {
                Preconditions.checkState((!((String)Preconditions.checkNotNull((Object)service, (Object)"service")).isEmpty() ? 1 : 0) != 0, (Object)"service must not be empty or null");
                this.service = service;
                this.method = method;
            }

            String getService() {
                return this.service;
            }

            String getMethod() {
                return this.method;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Name name = (Name)o;
                return com.google.common.base.Objects.equal((Object)this.service, (Object)name.service) && com.google.common.base.Objects.equal((Object)this.method, (Object)name.method);
            }

            public int hashCode() {
                return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.service, this.method});
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("service", (Object)this.service).add("method", (Object)this.method).toString();
            }
        }
    }

    @Immutable
    static final class NameMatcher {
        private final String key;
        private final ImmutableList<String> names;
        private final boolean optional;

        NameMatcher(String key, List<String> names, @Nullable Boolean optional) {
            this.key = (String)Preconditions.checkNotNull((Object)key, (Object)"key");
            this.names = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(names, (Object)"names")));
            this.optional = optional != null ? optional : true;
        }

        String getKey() {
            return this.key;
        }

        ImmutableList<String> names() {
            return this.names;
        }

        boolean isOptional() {
            return this.optional;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NameMatcher matcher = (NameMatcher)o;
            return this.optional == matcher.optional && Objects.equals(this.key, matcher.key) && Objects.equals(this.names, matcher.names);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.names, this.optional);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", (Object)this.key).add("names", this.names).add("optional", this.optional).toString();
        }
    }

    @Immutable
    static final class RouteLookupConfig {
        private static final long MAX_AGE_MILLIS = TimeUnit.MINUTES.toMillis(5L);
        private final ImmutableList<GrpcKeyBuilder> grpcKeyBuilders;
        private final String lookupService;
        private final long lookupServiceTimeoutInMillis;
        private final long maxAgeInMillis;
        private final long staleAgeInMillis;
        private final long cacheSizeBytes;
        private final ImmutableList<String> validTargets;
        @Nullable
        private final String defaultTarget;

        RouteLookupConfig(List<GrpcKeyBuilder> grpcKeyBuilders, String lookupService, long lookupServiceTimeoutInMillis, @Nullable Long maxAgeInMillis, @Nullable Long staleAgeInMillis, long cacheSizeBytes, List<String> validTargets, @Nullable String defaultTarget) {
            Preconditions.checkState((!((List)Preconditions.checkNotNull(grpcKeyBuilders, (Object)"grpcKeyBuilders")).isEmpty() ? 1 : 0) != 0, (Object)"must have at least one GrpcKeyBuilder");
            RlsProtoData.checkUniqueName(grpcKeyBuilders);
            this.grpcKeyBuilders = ImmutableList.copyOf(grpcKeyBuilders);
            Preconditions.checkState((lookupService != null && !lookupService.isEmpty() ? 1 : 0) != 0, (Object)"lookupService must not be empty");
            this.lookupService = lookupService;
            Preconditions.checkState((lookupServiceTimeoutInMillis > 0L ? 1 : 0) != 0, (Object)"lookupServiceTimeoutInMillis should be positive");
            this.lookupServiceTimeoutInMillis = lookupServiceTimeoutInMillis;
            if (maxAgeInMillis == null) {
                Preconditions.checkState((staleAgeInMillis == null ? 1 : 0) != 0, (Object)"To specify staleAgeInMillis, must have maxAgeInMillis");
            }
            if (maxAgeInMillis == null || maxAgeInMillis == 0L) {
                maxAgeInMillis = MAX_AGE_MILLIS;
            }
            if (staleAgeInMillis == null || staleAgeInMillis == 0L) {
                staleAgeInMillis = MAX_AGE_MILLIS;
            }
            this.maxAgeInMillis = Math.min(maxAgeInMillis, MAX_AGE_MILLIS);
            this.staleAgeInMillis = Math.min(staleAgeInMillis, this.maxAgeInMillis);
            Preconditions.checkArgument((cacheSizeBytes > 0L ? 1 : 0) != 0, (Object)"cacheSize must be positive");
            this.cacheSizeBytes = cacheSizeBytes;
            this.validTargets = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(validTargets, (Object)"validTargets")));
            this.defaultTarget = defaultTarget;
        }

        ImmutableList<GrpcKeyBuilder> getGrpcKeyBuilders() {
            return this.grpcKeyBuilders;
        }

        String getLookupService() {
            return this.lookupService;
        }

        long getLookupServiceTimeoutInMillis() {
            return this.lookupServiceTimeoutInMillis;
        }

        long getMaxAgeInMillis() {
            return this.maxAgeInMillis;
        }

        long getStaleAgeInMillis() {
            return this.staleAgeInMillis;
        }

        long getCacheSizeBytes() {
            return this.cacheSizeBytes;
        }

        ImmutableList<String> getValidTargets() {
            return this.validTargets;
        }

        String getDefaultTarget() {
            return this.defaultTarget;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RouteLookupConfig that = (RouteLookupConfig)o;
            return this.lookupServiceTimeoutInMillis == that.lookupServiceTimeoutInMillis && this.maxAgeInMillis == that.maxAgeInMillis && this.staleAgeInMillis == that.staleAgeInMillis && this.cacheSizeBytes == that.cacheSizeBytes && com.google.common.base.Objects.equal(this.grpcKeyBuilders, that.grpcKeyBuilders) && com.google.common.base.Objects.equal((Object)this.lookupService, (Object)that.lookupService) && com.google.common.base.Objects.equal((Object)this.defaultTarget, (Object)that.defaultTarget);
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.grpcKeyBuilders, this.lookupService, this.lookupServiceTimeoutInMillis, this.maxAgeInMillis, this.staleAgeInMillis, this.cacheSizeBytes, this.defaultTarget});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("grpcKeyBuilders", this.grpcKeyBuilders).add("lookupService", (Object)this.lookupService).add("lookupServiceTimeoutInMillis", this.lookupServiceTimeoutInMillis).add("maxAgeInMillis", this.maxAgeInMillis).add("staleAgeInMillis", this.staleAgeInMillis).add("cacheSize", this.cacheSizeBytes).add("defaultTarget", (Object)this.defaultTarget).toString();
        }
    }

    @Immutable
    static final class RouteLookupResponse {
        private final ImmutableList<String> targets;
        private final String headerData;

        RouteLookupResponse(List<String> targets, String headerData) {
            Preconditions.checkState((targets != null && !targets.isEmpty() ? 1 : 0) != 0, (Object)"targets cannot be empty or null");
            this.targets = ImmutableList.copyOf(targets);
            this.headerData = (String)Preconditions.checkNotNull((Object)headerData, (Object)"headerData");
        }

        ImmutableList<String> getTargets() {
            return this.targets;
        }

        String getHeaderData() {
            return this.headerData;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RouteLookupResponse that = (RouteLookupResponse)o;
            return Objects.equals(this.targets, that.targets) && Objects.equals(this.headerData, that.headerData);
        }

        public int hashCode() {
            return Objects.hash(this.targets, this.headerData);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("targets", this.targets).add("headerData", (Object)this.headerData).toString();
        }
    }

    @Immutable
    static final class RouteLookupRequest {
        private final String server;
        private final String path;
        private final String targetType;
        private final ImmutableMap<String, String> keyMap;

        RouteLookupRequest(String server, String path, String targetType, Map<String, String> keyMap) {
            this.server = (String)Preconditions.checkNotNull((Object)server, (Object)"server");
            this.path = (String)Preconditions.checkNotNull((Object)path, (Object)"path");
            this.targetType = (String)Preconditions.checkNotNull((Object)targetType, (Object)"targetName");
            this.keyMap = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(keyMap, (Object)"keyMap")));
        }

        String getServer() {
            return this.server;
        }

        String getPath() {
            return this.path;
        }

        String getTargetType() {
            return this.targetType;
        }

        ImmutableMap<String, String> getKeyMap() {
            return this.keyMap;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RouteLookupRequest that = (RouteLookupRequest)o;
            return com.google.common.base.Objects.equal((Object)this.server, (Object)that.server) && com.google.common.base.Objects.equal((Object)this.path, (Object)that.path) && com.google.common.base.Objects.equal((Object)this.targetType, (Object)that.targetType) && com.google.common.base.Objects.equal(this.keyMap, that.keyMap);
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.server, this.path, this.targetType, this.keyMap});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("server", (Object)this.server).add("path", (Object)this.path).add("targetName", (Object)this.targetType).add("keyMap", this.keyMap).toString();
        }
    }
}

