/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.collect.ImmutableList;
import io.grpc.Attributes;
import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.CompositeChannelCredentials;
import io.grpc.ExperimentalApi;
import io.grpc.Status;
import io.grpc.alts.FailingCallCredentials;
import io.grpc.alts.HandshakerServiceChannel;
import io.grpc.alts.internal.AltsProtocolNegotiator;
import io.grpc.auth.MoreCallCredentials;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.SharedResourcePool;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.InternalNettyChannelCredentials;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/7479")
public final class GoogleDefaultChannelCredentials {
    private static Logger logger = Logger.getLogger(GoogleDefaultChannelCredentials.class.getName());

    private GoogleDefaultChannelCredentials() {
    }

    public static ChannelCredentials create() {
        CallCredentials callCredentials;
        ChannelCredentials nettyCredentials = InternalNettyChannelCredentials.create((InternalProtocolNegotiator.ClientFactory)GoogleDefaultChannelCredentials.createClientFactory());
        try {
            callCredentials = MoreCallCredentials.from((Credentials)GoogleCredentials.getApplicationDefault());
        }
        catch (IOException e) {
            callCredentials = new FailingCallCredentials(Status.UNAUTHENTICATED.withDescription("Failed to get Google default credentials").withCause((Throwable)e));
        }
        return CompositeChannelCredentials.create((ChannelCredentials)nettyCredentials, (CallCredentials)callCredentials);
    }

    private static InternalProtocolNegotiator.ClientFactory createClientFactory() {
        SslContext sslContext;
        try {
            sslContext = GrpcSslContexts.forClient().build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
        Attributes.Key clusterNameAttrKey = null;
        try {
            Class<?> klass = Class.forName("io.grpc.xds.InternalXdsAttributes");
            clusterNameAttrKey = (Attributes.Key)klass.getField("ATTR_CLUSTER_NAME").get(null);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.FINE, "Unable to load xDS endpoint cluster name key, this may be expected", e);
        }
        catch (NoSuchFieldException e) {
            logger.log(Level.FINE, "Unable to load xDS endpoint cluster name key, this may be expected", e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.FINE, "Unable to load xDS endpoint cluster name key, this may be expected", e);
        }
        return new AltsProtocolNegotiator.GoogleDefaultProtocolNegotiatorFactory((List<String>)ImmutableList.of(), (ObjectPool<Channel>)SharedResourcePool.forResource(HandshakerServiceChannel.SHARED_HANDSHAKER_CHANNEL), sslContext, (Attributes.Key<String>)clusterNameAttrKey);
    }
}

