/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.aas;

import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.AuthenticationDescriptor;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import de.iip_ecosphere.platform.support.net.KeyStoreDescriptor;
import java.util.HashMap;
import java.util.Map;

public class BasicSetupSpec
implements SetupSpec {
    private Map<SetupSpec.AasComponent, BasicComponentSetup> setups = new HashMap<SetupSpec.AasComponent, BasicComponentSetup>();
    private BasicSetupSpec from;
    private String assetServerProtocol;

    public BasicSetupSpec() {
        this((Endpoint)null);
    }

    public BasicSetupSpec(String protocol, int port) {
        this(protocol, "localhost", port);
    }

    public BasicSetupSpec(String protocol, String host, int port) {
        this();
        this.setAssetServerAddress(new ServerAddress(Schema.IGNORE, host, port), protocol);
    }

    public BasicSetupSpec(Endpoint registryEndpoint) {
        this(registryEndpoint, registryEndpoint, (Endpoint)null, (Endpoint)null);
    }

    public BasicSetupSpec(Endpoint registryEndpoint, ServerAddress repositoryAddress) {
        this(registryEndpoint, repositoryAddress, null);
    }

    public BasicSetupSpec(Endpoint registryEndpoint, ServerAddress repositoryAddress, KeyStoreDescriptor desc) {
        this(registryEndpoint, repositoryAddress, desc, null);
    }

    public BasicSetupSpec(Endpoint registryEndpoint, ServerAddress repositoryAddress, KeyStoreDescriptor kDesc, AuthenticationDescriptor aDesc) {
        this(registryEndpoint, new Endpoint(repositoryAddress, ""), kDesc, aDesc);
    }

    public BasicSetupSpec(Endpoint registryEndpoint, Endpoint repositoryEndpoint, KeyStoreDescriptor kDesc, AuthenticationDescriptor aDesc) {
        this(registryEndpoint, repositoryEndpoint);
        this.setAasRepositoryKeystore(kDesc);
        this.setSubmodelRepositoryKeystore(kDesc);
        this.setAasRegistryKeystore(kDesc);
        this.setSubmodelRegistryKeystore(kDesc);
        this.setAssetServerKeystore(kDesc);
        this.setAuthentication(aDesc);
    }

    public BasicSetupSpec(Endpoint registryEndpoint, Endpoint repositoryEndpoint) {
        this(registryEndpoint, new Endpoint(registryEndpoint.getSchema(), ""), repositoryEndpoint, new Endpoint(repositoryEndpoint.getSchema(), ""));
    }

    public BasicSetupSpec(Endpoint aasRegistryEndpoint, Endpoint smRegistryEndpoint, Endpoint aasRepositoryEndpoint, Endpoint smRepositoryEndpoint) {
        for (SetupSpec.AasComponent c : SetupSpec.AasComponent.values()) {
            this.setups.put(c, new BasicComponentSetup(c));
        }
        this.assetServerProtocol = "";
        this.setRegistryEndpoints(aasRegistryEndpoint, smRegistryEndpoint);
        this.setups.get((Object)((Object)SetupSpec.AasComponent.AAS_REPOSITORY)).endpoint = aasRepositoryEndpoint;
        this.setups.get((Object)((Object)SetupSpec.AasComponent.SUBMODEL_REPOSITORY)).endpoint = smRepositoryEndpoint;
    }

    public BasicSetupSpec(SetupSpec spec) {
        for (SetupSpec.AasComponent c : SetupSpec.AasComponent.values()) {
            this.setups.put(c, new BasicComponentSetup(c));
        }
        this.assetServerProtocol = "";
        if (spec instanceof BasicSetupSpec) {
            this.from = (BasicSetupSpec)spec;
            for (SetupSpec.AasComponent c : SetupSpec.AasComponent.values()) {
                this.setups.get((Object)((Object)c)).state = this.from.setups.get((Object)((Object)c)).state;
                this.setups.get((Object)((Object)c)).serverAddress = this.from.setups.get((Object)((Object)c)).serverAddress;
                this.setups.get((Object)((Object)c)).endpoint = this.from.setups.get((Object)((Object)c)).endpoint;
                this.setups.get((Object)((Object)c)).keyStore = this.from.setups.get((Object)((Object)c)).keyStore;
                this.setups.get((Object)((Object)c)).authentication = this.from.setups.get((Object)((Object)c)).authentication;
            }
        } else {
            for (SetupSpec.AasComponent c : SetupSpec.AasComponent.values()) {
                this.setups.get((Object)((Object)c)).state = spec.getSetup(c).getState();
                this.setups.get((Object)((Object)c)).serverAddress = spec.getSetup(c).getServerAddress();
                this.setups.get((Object)((Object)c)).endpoint = spec.getSetup(c).getEndpoint();
                this.setups.get((Object)((Object)c)).keyStore = spec.getSetup(c).getKeyStore();
                this.setups.get((Object)((Object)c)).authentication = spec.getSetup(c).getAuthentication();
            }
        }
        this.assetServerProtocol = spec.getAssetServerProtocol();
    }

    public BasicSetupSpec setAuthentication(AuthenticationDescriptor aDesc) {
        this.setAasRepositoryAuthentication(aDesc);
        this.setSubmodelRepositoryAuthentication(aDesc);
        this.setAasRegistryAuthentication(aDesc);
        this.setSubmodelRegistryAuthentication(aDesc);
        this.setAssetServerAuthentication(aDesc);
        return this;
    }

    public BasicSetupSpec setAasRepositoryEndpoint(Endpoint endpoint) {
        this.setups.get((Object)((Object)SetupSpec.AasComponent.AAS_REPOSITORY)).endpoint = endpoint;
        return this;
    }

    public BasicSetupSpec setRegistryEndpoint(Endpoint endpoint) {
        this.setups.get((Object)((Object)SetupSpec.AasComponent.AAS_REGISTRY)).endpoint = endpoint;
        return this;
    }

    public BasicSetupSpec setRegistryEndpoints(Endpoint aasRegistryEndpoint, Endpoint smRegistryEndpoint) {
        this.setups.get((Object)((Object)SetupSpec.AasComponent.AAS_REGISTRY)).endpoint = aasRegistryEndpoint;
        this.setups.get((Object)((Object)SetupSpec.AasComponent.SUBMODEL_REGISTRY)).endpoint = smRegistryEndpoint;
        return this;
    }

    public BasicSetupSpec setAasRepositoryKeystore(KeyStoreDescriptor desc) {
        this.setups.get((Object)((Object)SetupSpec.AasComponent.AAS_REPOSITORY)).keyStore = desc;
        return this;
    }

    public BasicSetupSpec setAasRepositoryAuthentication(AuthenticationDescriptor desc) {
        this.setups.get((Object)((Object)SetupSpec.AasComponent.AAS_REPOSITORY)).authentication = desc;
        return this;
    }

    public BasicSetupSpec setSubmodelRepositoryKeystore(KeyStoreDescriptor desc) {
        this.setups.get((Object)((Object)SetupSpec.AasComponent.SUBMODEL_REPOSITORY)).keyStore = desc;
        return this;
    }

    public BasicSetupSpec setSubmodelRepositoryAuthentication(AuthenticationDescriptor desc) {
        this.setups.get((Object)((Object)SetupSpec.AasComponent.SUBMODEL_REPOSITORY)).authentication = desc;
        return this;
    }

    public BasicSetupSpec setAasRegistryKeystore(KeyStoreDescriptor desc) {
        this.setups.get((Object)((Object)SetupSpec.AasComponent.AAS_REGISTRY)).keyStore = desc;
        return this;
    }

    public BasicSetupSpec setAasRegistryAuthentication(AuthenticationDescriptor desc) {
        this.setups.get((Object)((Object)SetupSpec.AasComponent.AAS_REGISTRY)).authentication = desc;
        return this;
    }

    public BasicSetupSpec setSubmodelRegistryKeystore(KeyStoreDescriptor desc) {
        this.setups.get((Object)((Object)SetupSpec.AasComponent.SUBMODEL_REGISTRY)).keyStore = desc;
        return this;
    }

    public BasicSetupSpec setSubmodelRegistryAuthentication(AuthenticationDescriptor desc) {
        this.setups.get((Object)((Object)SetupSpec.AasComponent.SUBMODEL_REGISTRY)).authentication = desc;
        return this;
    }

    @Override
    public boolean areRegistriesRunning() {
        return false;
    }

    public BasicSetupSpec setAssetServerAddress(ServerAddress address) {
        return this.setAssetServerAddress(address, this.assetServerProtocol);
    }

    public BasicSetupSpec setAssetServerAddress(ServerAddress address, String protocol) {
        this.setups.get((Object)((Object)SetupSpec.AasComponent.ASSET)).serverAddress = address;
        this.assetServerProtocol = protocol;
        return this;
    }

    @Override
    public String getAssetServerProtocol() {
        return this.assetServerProtocol;
    }

    public BasicSetupSpec setAssetServerKeystore(KeyStoreDescriptor desc) {
        this.setups.get((Object)((Object)SetupSpec.AasComponent.ASSET)).keyStore = desc;
        return this;
    }

    public BasicSetupSpec setAssetServerAuthentication(AuthenticationDescriptor desc) {
        this.setups.get((Object)((Object)SetupSpec.AasComponent.ASSET)).authentication = desc;
        return this;
    }

    private String toString(KeyStoreDescriptor desc) {
        return " keystore: " + (desc != null);
    }

    private String toString(ServerAddress address) {
        return null == address ? "-" : address.toUri();
    }

    private String toString(SetupSpec.ComponentSetup setup) {
        return this.toString((ServerAddress)setup.getEndpoint()) + this.toString(setup.getKeyStore());
    }

    @Override
    public SetupSpec.ComponentSetup getSetup(SetupSpec.AasComponent component) {
        return this.setups.get((Object)component);
    }

    public String toString() {
        String cr = System.lineSeparator();
        return "Basic AAS setup specification:" + cr + " - AAS registry:        " + this.toString(this.getSetup(SetupSpec.AasComponent.AAS_REGISTRY)) + cr + " - AAS repository:      " + this.toString(this.getSetup(SetupSpec.AasComponent.AAS_REPOSITORY)) + cr + " - Submodel registry:   " + this.toString(this.getSetup(SetupSpec.AasComponent.SUBMODEL_REGISTRY)) + cr + " - Submodel repository: " + this.toString(this.getSetup(SetupSpec.AasComponent.SUBMODEL_REPOSITORY)) + cr + " - Asset server:        " + this.toString(this.getSetup(SetupSpec.AasComponent.ASSET)) + " @ '" + this.assetServerProtocol + "'";
    }

    protected class BasicComponentSetup
    implements SetupSpec.ComponentSetup {
        private ServerAddress serverAddress;
        private Endpoint endpoint;
        private KeyStoreDescriptor keyStore;
        private SetupSpec.State state = SetupSpec.State.STOPPED;
        private AuthenticationDescriptor authentication;
        private SetupSpec.AasComponent component;

        protected BasicComponentSetup(SetupSpec.AasComponent component) {
            this.component = component;
        }

        @Override
        public ServerAddress getServerAddress() {
            return null == this.serverAddress ? this.endpoint : this.serverAddress;
        }

        @Override
        public Endpoint getEndpoint() {
            return this.endpoint;
        }

        @Override
        public KeyStoreDescriptor getKeyStore() {
            return this.keyStore;
        }

        @Override
        public AuthenticationDescriptor getAuthentication() {
            return this.authentication;
        }

        @Override
        public SetupSpec.State getState() {
            return null == BasicSetupSpec.this.from ? this.state : BasicSetupSpec.this.from.getSetup(this.component).getState();
        }

        @Override
        public void notifyStateChange(SetupSpec.State state) {
            if (null == BasicSetupSpec.this.from) {
                this.state = state;
            } else {
                BasicSetupSpec.this.from.getSetup(this.component).notifyStateChange(state);
            }
        }
    }
}

