/*
 * Decompiled with CFR 0.152.
 */
package de.oktoflow.platform.support.rest.spark;

import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.rest.Rest;
import de.iip_ecosphere.platform.support.rest.RestTarget;
import de.oktoflow.platform.support.rest.spark.JerseyWebTarget;
import spark.Filter;
import spark.Request;
import spark.Response;
import spark.Route;
import spark.Service;

public class SparkRest
extends Rest {
    public Rest.RestServer createServer(int port) {
        return new SparkRestServer(port);
    }

    public RestTarget createTarget(String uri) {
        return new JerseyWebTarget(uri);
    }

    private static class SparkRestServer
    implements Rest.RestServer {
        private Service service;

        private SparkRestServer(int port) {
            this.service = Service.ignite().port(port);
            this.service.initExceptionHandler(e -> LoggerFactory.getLogger((Object)this).error(e.getMessage(), (Throwable)e));
        }

        private Route createRoute(Rest.Route route) {
            return (req, res) -> route.handle((Rest.Request)new SparkRequest(req), (Rest.Response)new SparkResponse(res));
        }

        private Filter createFilter(Rest.Filter filter) {
            return (req, res) -> filter.handle((Rest.Request)new SparkRequest(req), (Rest.Response)new SparkResponse(res));
        }

        public void definePost(String path, Rest.Route route) {
            this.service.post(path, this.createRoute(route));
        }

        public void defineGet(String path, Rest.Route route) {
            this.service.get(path, this.createRoute(route));
        }

        public void definePut(String path, Rest.Route route) {
            this.service.put(path, this.createRoute(route));
        }

        public void defineDelete(String path, Rest.Route route) {
            this.service.delete(path, this.createRoute(route));
        }

        public void defineBefore(Rest.Filter filter) {
            this.service.before(this.createFilter(filter));
        }

        public void defineBefore(String path, Rest.Filter filter) {
            this.service.before(path, this.createFilter(filter));
        }

        public void halt(int status, String body) {
            this.service.halt(status, body);
        }

        public Server start() {
            this.service.awaitInitialization();
            return this;
        }

        public void stop(boolean dispose) {
            this.service.stop();
            this.service.awaitStop();
        }

        public boolean supportsPathVariables() {
            return true;
        }

        public String toPathVariable(String name) {
            return ":" + name;
        }

        public void secure(String keystoreFile, String keystorePassword, String certAlias) {
            this.service = this.service.secure(keystoreFile, keystorePassword, certAlias, null, null);
        }

        public void addExceptionHandler(Class<Exception> cls, Rest.ExceptionHandler handler) {
            this.service.exception(cls, (ex, req, res) -> handler.handle(ex, (Rest.Request)new SparkRequest(req), (Rest.Response)new SparkResponse(res)));
        }
    }

    private static class SparkResponse
    implements Rest.Response {
        private Response response;

        private SparkResponse(Response response) {
            this.response = response;
        }

        public void setBody(String body) {
            this.response.body(body);
        }

        public String getBody() {
            return this.response.body();
        }

        public void setStatus(int status) {
            this.response.status(status);
        }

        public void setType(String type) {
            this.response.type(type);
        }
    }

    private static class SparkRequest
    implements Rest.Request {
        private Request request;

        private SparkRequest(Request request) {
            this.request = request;
        }

        public String getBody() {
            return this.request.body();
        }

        public String getParam(String name) {
            return this.request.params(name);
        }

        public String getContentType() {
            return this.request.contentType();
        }

        public String getQueryString() {
            return this.request.queryString();
        }

        public String getPath() {
            return this.request.pathInfo();
        }
    }
}

