/*
 * Decompiled with CFR 0.152.
 */
package de.oktoflow.platform.support.ssh.sshd;

import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.ssh.Ssh;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.SystemUtils;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.shell.ProcessShellFactory;
import org.apache.sshd.server.shell.ShellFactory;

public class SshdSsh
extends Ssh {
    public Ssh.SshServer createServer(ServerAddress address) throws IOException {
        return new SshdServer(address);
    }

    private class SshdServer
    implements Ssh.SshServer {
        private SshServer server;
        private boolean started = false;
        private ServerAddress address;
        private Ssh.Authenticator authenticator;
        private String shellCommand = "/bin/sh -i -l";
        private String[] shellArgs = new String[]{"/bin/sh", "-i", "-l"};
        private File hostKeyFile;

        private SshdServer(ServerAddress address) {
            this.address = address;
        }

        public Ssh.SshServer start() {
            if (this.server == null && !this.started) {
                this.server = SshServer.setUpDefaultServer();
                this.server.setHost(this.address.getHost());
                this.server.setPort(this.address.getPort());
                if (null != this.hostKeyFile) {
                    this.server.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider(this.hostKeyFile.toPath()));
                }
                this.server.setPasswordAuthenticator((username, password, session) -> null != this.authenticator && this.authenticator.authenticate(username, password));
                if (SystemUtils.IS_OS_WINDOWS) {
                    LoggerFactory.getLogger(SshdSsh.class).error("Cannot start SSH server on Windows.");
                    this.server = null;
                    return null;
                }
                this.server.setShellFactory((ShellFactory)new ProcessShellFactory(this.shellCommand, this.shellArgs));
                try {
                    this.server.start();
                    this.started = true;
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(SshdSsh.class).error("Cannot start SSH server: " + e.getMessage());
                    this.server = null;
                    return null;
                }
            }
            return this;
        }

        public void stop(boolean dispose) {
            if (null != this.server) {
                try {
                    this.server.stop(true);
                    this.started = false;
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(SshdSsh.class).error("Stopping SSH server: " + e.getMessage());
                }
            }
        }

        public void setAuthenticator(Ssh.Authenticator authenticator) {
            this.authenticator = authenticator;
        }

        public void setShellInit(String command, String ... args) {
            if (command != null && args != null) {
                this.shellCommand = command;
                this.shellArgs = args;
            }
        }

        public void setHostKey(File hostKeyFile) {
            this.hostKeyFile = hostKeyFile;
        }

        public boolean isStarted() {
            return this.started;
        }
    }
}

