/*
 * Decompiled with CFR 0.152.
 */
package test.de.oktoflow.platform.support.ws.websocket;

import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.websocket.WebsocketFactory;
import de.oktoflow.platform.support.ws.websocket.WebsocketWebsocketFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class WebsocketFactoryTest {
    @Test
    public void testWs() throws IOException, URISyntaxException {
        WebsocketFactory ws = WebsocketFactory.getInstance();
        Assert.assertTrue((boolean)(ws instanceof WebsocketWebsocketFactory));
        ServerAddress address = new ServerAddress(Schema.WS);
        Server server = ws.createBroadcastingServer(address);
        server.start();
        ArrayList received = new ArrayList();
        URI serverURI = new URI(address.toServerUri());
        WebsocketFactory.WebSocket sender = ws.createSocket(serverURI);
        WsStatusListener senderListener = new WsStatusListener();
        sender.setStatusListener((WebsocketFactory.StatusListener)senderListener);
        WebsocketFactory.WebSocket receiver = ws.createSocket(serverURI);
        WsStatusListener receiverListener = new WsStatusListener();
        receiver.setStatusListener((WebsocketFactory.StatusListener)receiverListener);
        receiver.setReceptionHander(s -> received.add(s));
        sender.connectBlocking();
        Assert.assertTrue((boolean)senderListener.connected);
        receiver.connect();
        TimeUtils.waitFor(() -> !receiverListener.connected, (int)3000, (int)200);
        Assert.assertTrue((boolean)receiverListener.connected);
        sender.send("ABC");
        TimeUtils.sleep((int)300);
        Assert.assertTrue((boolean)received.contains("ABC"));
        sender.close();
        TimeUtils.waitFor(() -> senderListener.connected, (int)3000, (int)200);
        Assert.assertTrue((!senderListener.connected ? 1 : 0) != 0);
        receiver.close();
        TimeUtils.waitFor(() -> receiverListener.connected, (int)3000, (int)200);
        Assert.assertTrue((!receiverListener.connected ? 1 : 0) != 0);
        server.stop(true);
    }

    private class WsStatusListener
    implements WebsocketFactory.StatusListener {
        private boolean connected = false;

        private WsStatusListener() {
        }

        public void onConnect() {
            this.connected = true;
        }

        public void onClose(String reason, boolean remote) {
            this.connected = false;
        }

        public void onError(String message) {
            System.out.println("ERROR: " + message);
        }
    }
}

