/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.tools.maven.python;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;

public class FilesetUtils {
    public static void addExcludedPaths(String[] paths, boolean isFile, Set<String> excluded) {
        for (String p : paths) {
            FilesetUtils.addExcludedPaths(p, isFile, excluded);
        }
    }

    public static void addExcludedPaths(String path, boolean isFile, Set<String> excluded) {
        excluded.add(path);
        String[] subPaths = path.replace("\\", "/").split("/");
        if (subPaths.length > 0) {
            String tmp = "";
            for (int i = 0; i < subPaths.length - (isFile ? 1 : 0); ++i) {
                if (i > 0) {
                    tmp = tmp + "/";
                }
                tmp = tmp + subPaths[i];
                excluded.add(tmp);
            }
        }
    }

    public static void deletePaths(FileSet fileset, String[] paths, Set<String> excluded, Log log) {
        FilesetUtils.iteratePaths(fileset, paths, excluded, file -> {
            log.info((CharSequence)("Deleting " + file));
            FileUtils.deleteQuietly((File)file);
        });
    }

    public static void iteratePaths(FileSet fileset, String[] paths, Set<String> excluded, Consumer<File> fileConsumer) {
        for (String p : paths) {
            if (excluded.contains(p)) continue;
            File file = new File(fileset.getDirectory(), p);
            fileConsumer.accept(file);
        }
    }

    public static void deletePaths(FileSet fileset, Log log) {
        FilesetUtils.determineFiles(fileset, true, file -> {
            if (null != log) {
                log.info((CharSequence)("Deleting " + file));
            }
            FileUtils.deleteQuietly((File)file);
        });
    }

    public static void determineFiles(FileSet fileset, boolean considerDirectories, Consumer<File> fileConsumer) {
        if (null != fileset) {
            FileSetManager fileSetManager = new FileSetManager();
            HashSet<String> excluded = new HashSet<String>();
            excluded.add("");
            excluded.add(".");
            if (considerDirectories) {
                FilesetUtils.addExcludedPaths(fileSetManager.getExcludedDirectories(fileset), false, excluded);
            }
            FilesetUtils.addExcludedPaths(fileSetManager.getExcludedFiles(fileset), true, excluded);
            FilesetUtils.iteratePaths(fileset, fileSetManager.getIncludedFiles(fileset), excluded, fileConsumer);
            if (considerDirectories) {
                FilesetUtils.iteratePaths(fileset, fileSetManager.getIncludedDirectories(fileset), excluded, fileConsumer);
            }
        }
    }

    public static Stream<File> streamFiles(FileSet fileset, boolean considerDirectories) {
        Stream.Builder resultBuilder = Stream.builder();
        FilesetUtils.determineFiles(fileset, considerDirectories, f -> resultBuilder.add(f));
        return resultBuilder.build();
    }

    public static List<File> listFiles(FileSet fileset, boolean considerDirectories) {
        ArrayList<File> result = new ArrayList<File>();
        FilesetUtils.determineFiles(fileset, considerDirectories, f -> result.add((File)f));
        return result;
    }

    public static void touch(File file, Log log) {
        if (file != null && file.getPath().length() > 0) {
            try {
                FileUtils.touch((File)file);
            }
            catch (IOException e) {
                log.warn((CharSequence)("Cannot touch " + file + ": " + e.getMessage()));
            }
        }
    }
}

