/*
 * Decompiled with CFR 0.152.
 */
package de.oktoflow.platform.support.yaml.snakeyaml;

import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.yaml.Yaml;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.representer.Representer;

public class SnakeYaml
extends Yaml {
    public Object load(InputStream in) throws IOException {
        org.yaml.snakeyaml.Yaml yaml = new org.yaml.snakeyaml.Yaml();
        return yaml.load(in);
    }

    public Map<String, Object> loadMapping(InputStream in) throws IOException {
        return (Map)this.load(in);
    }

    public <T> T loadAs(String in, Class<T> cls) throws IOException {
        return (T)SnakeYaml.createYaml(cls).loadAs(in, cls);
    }

    public <T> T loadAs(InputStream in, Class<T> cls) throws IOException {
        return (T)SnakeYaml.createYaml(cls).loadAs(in, cls);
    }

    public Iterator<Object> loadAll(InputStream in, String path, Class<?> cls) throws IOException {
        Iterator<Object> it = null;
        try {
            if (path != null && path.length() > 0) {
                org.yaml.snakeyaml.Yaml yaml = SnakeYaml.createYaml(Map.class);
                ArrayList<Object> documents = new ArrayList<Object>();
                try {
                    for (Object o : yaml.loadAll(in)) {
                        if (o instanceof Map) {
                            Map map = (Map)o;
                            Map data = (Map)map.get(path);
                            if (data != null) {
                                documents.add(yaml.loadAs(yaml.dump((Object)data), cls));
                                continue;
                            }
                            LoggerFactory.getLogger((Object)((Object)this)).warn("Cannot find YAML path {}, falling back to full document", (Object)path);
                            continue;
                        }
                        LoggerFactory.getLogger((Object)((Object)this)).warn("Cannot read data, instance is of type {}", o == null ? null : o.getClass().getName());
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (documents.size() > 0) {
                    it = documents.iterator();
                }
            }
            if (it == null) {
                it = SnakeYaml.createYaml(cls).loadAll(in).iterator();
            }
            if (null != cls) {
                Object o;
                ArrayList results = new ArrayList();
                if (it.hasNext() && cls.isInstance(o = it.next())) {
                    results.add(cls.cast(o));
                }
                it = results.iterator();
            }
        }
        catch (YAMLException e) {
            throw new IOException(e);
        }
        return it;
    }

    public Iterator<Object> loadAll(InputStream in) throws IOException {
        return this.loadAll(in, null);
    }

    private static org.yaml.snakeyaml.Yaml createYaml(Class<?> cls) {
        Representer representer = new Representer(new DumperOptions());
        representer.getPropertyUtils().setSkipMissingProperties(true);
        org.yaml.snakeyaml.Yaml result = null == cls ? new org.yaml.snakeyaml.Yaml(representer) : new org.yaml.snakeyaml.Yaml((BaseConstructor)new Constructor(cls), representer);
        return result;
    }

    public <T> T loadTolerantAs(InputStream in, Class<T> cls) {
        Representer representer = new Representer(new DumperOptions());
        representer.getPropertyUtils().setSkipMissingProperties(true);
        org.yaml.snakeyaml.Yaml yaml = new org.yaml.snakeyaml.Yaml((BaseConstructor)new Constructor(cls, new LoaderOptions()), representer);
        return (T)yaml.load(in);
    }

    public String dump(Object object) throws IOException {
        return new org.yaml.snakeyaml.Yaml().dump(object);
    }

    public void dump(Object object, Class<?> cls, Writer out) throws IOException {
        Constructor constructor = new Constructor(cls);
        TypeDescription configDescription = new TypeDescription(cls);
        constructor.addTypeDescription(configDescription);
        org.yaml.snakeyaml.Yaml yaml = new org.yaml.snakeyaml.Yaml((BaseConstructor)constructor);
        yaml.dump(object, out);
    }
}

