/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import de.iip_ecosphere.platform.support.json.IOIterator;
import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.support.json.JsonArrayBuilder;
import de.iip_ecosphere.platform.support.json.JsonIterator;
import de.iip_ecosphere.platform.support.json.JsonObject;
import de.iip_ecosphere.platform.support.json.JsonObjectBuilder;
import de.iip_ecosphere.platform.support.json.JsonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.Set;
import test.de.iip_ecosphere.platform.support.json.TestJsonObject;

public class TestJson
extends Json {
    private ObjectMapper mapper = new ObjectMapper();
    private ObjectWriter writer;

    public Json createInstanceImpl() {
        return new TestJson();
    }

    public String toJson(Object obj) throws IOException {
        String result = "";
        if (null != obj) {
            try {
                result = null != this.writer ? this.writer.writeValueAsString(obj) : this.mapper.writeValueAsString(obj);
            }
            catch (JsonProcessingException e) {
                throw new IOException(e);
            }
        }
        return result;
    }

    public <R> R fromJson(Object json, Class<R> cls) throws IOException {
        Object result = null;
        if (null != json) {
            try {
                result = this.mapper.readValue(json.toString(), cls);
            }
            catch (JsonProcessingException e) {
                throw new IOException(e);
            }
        }
        return (R)result;
    }

    public <R> List<R> listFromJson(Object json, Class<R> cls) {
        List result = null;
        if (null != json) {
            try {
                result = (List)this.mapper.readValue(json.toString(), new ListTypeReference());
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return result;
    }

    public <K, V> Map<K, V> mapFromJson(Object json, Class<K> keyCls, Class<K> valueCls) {
        Map result = null;
        if (null != json) {
            try {
                result = (Map)this.mapper.readValue(json.toString(), new MapTypeReference());
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return result;
    }

    public <T> T readValue(String src, Class<T> cls) throws IOException {
        try {
            return (T)this.mapper.readValue(src, cls);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    public <T> T readValue(byte[] src, Class<T> valueType) throws IOException {
        try {
            return (T)this.mapper.readValue(src, valueType);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    public byte[] writeValueAsBytes(Object value) throws IOException {
        try {
            if (this.writer != null) {
                return this.writer.writeValueAsBytes(value);
            }
            return this.mapper.writeValueAsBytes(value);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    public Json configureFor(Class<?> cls) {
        this.mapper = JsonUtils.configureFor((ObjectMapper)this.mapper, cls);
        return this;
    }

    public Json handleIipDataClasses() {
        this.mapper = JsonUtils.handleIipDataClasses((ObjectMapper)this.mapper);
        return this;
    }

    public Json defineOptionals(Class<?> cls, String ... fieldNames) {
        this.mapper = JsonUtils.defineOptionals((ObjectMapper)this.mapper, cls, (String[])fieldNames);
        return this;
    }

    public Json defineFields(String ... fieldNames) {
        this.mapper = JsonUtils.defineFields((ObjectMapper)this.mapper, (String[])fieldNames);
        return this;
    }

    public Json exceptFields(String ... fieldNames) {
        this.mapper = JsonUtils.exceptFields((ObjectMapper)this.mapper, (String[])fieldNames);
        return this;
    }

    public Json filterAllExceptFields(String ... fieldNames) {
        SimpleBeanPropertyFilter theFilter = SimpleBeanPropertyFilter.serializeAllExcept((String[])fieldNames);
        SimpleFilterProvider filters = new SimpleFilterProvider().setDefaultFilter(theFilter);
        this.writer = this.mapper.writer((FilterProvider)filters);
        return this;
    }

    public <T> T convertValue(Object value, Class<T> cls) throws IllegalArgumentException {
        return (T)this.mapper.convertValue(value, cls);
    }

    public Json failOnUnknownProperties(boolean fail) {
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return this;
    }

    public <T> Json.EnumMapping<T> createEnumMapping(Class<T> type, Map<String, T> mapping) {
        return new JsonUtils.JacksonEnumMapping(type, mapping);
    }

    public Json declareEnums(Json.EnumMapping<?> ... mappings) {
        JsonUtils.declareEnums((ObjectMapper)this.mapper, mappings);
        return this;
    }

    public Json configureLazy(Set<Object> ignore) {
        JsonUtils.configureLazy((ObjectMapper)this.mapper, ignore);
        return this;
    }

    public <T> IOIterator<T> createIterator(InputStream stream, Class<T> cls) throws IOException {
        return JsonUtils.createIterator((ObjectMapper)this.mapper, (InputStream)stream, cls);
    }

    protected JsonObject createObjectImpl(Reader reader) throws IOException {
        return TestJsonObject.createObject(reader);
    }

    protected JsonObjectBuilder createObjectBuilderImpl() {
        return TestJsonObject.createObjectBuilder();
    }

    protected JsonArrayBuilder createArrayBuilderImpl() {
        return TestJsonObject.createArrayBuilder();
    }

    protected JsonIterator parseImpl(String text) {
        return null;
    }

    protected JsonIterator parseImpl(byte[] data) {
        return null;
    }

    private static class ListTypeReference<T>
    extends TypeReference<List<T>> {
        private ListTypeReference() {
        }
    }

    private static class MapTypeReference<K, V>
    extends TypeReference<Map<K, V>> {
        private MapTypeReference() {
        }
    }
}

