/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.OsUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class FileUtils {
    private FileUtils() {
    }

    public static File createTmpFolder(String name) {
        return FileUtils.createTmpFolder(name, false);
    }

    public static File createTmpFolder(String name, boolean cleanup) {
        String tmp = System.getProperty("java.io.tmpdir");
        File result = new File(tmp, name);
        if (result.exists() && !FileUtils.deleteQuietly(result)) {
            result = new File(tmp, name + "_" + System.currentTimeMillis());
        }
        result.mkdir();
        if (cleanup) {
            result.deleteOnExit();
        }
        return result;
    }

    public static boolean deleteQuietly(File file) {
        return org.apache.commons.io.FileUtils.deleteQuietly((File)file);
    }

    public static void forceDelete(File file) throws IOException {
        org.apache.commons.io.FileUtils.forceDelete((File)file);
    }

    public static void deleteOnExit(File file) {
        try {
            if (null != file) {
                org.apache.commons.io.FileUtils.forceDeleteOnExit((File)file);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getTempDirectoryPath() {
        return org.apache.commons.io.FileUtils.getTempDirectoryPath();
    }

    public static File getTempDirectory() {
        return org.apache.commons.io.FileUtils.getTempDirectory();
    }

    public static File getUserDirectory() {
        return org.apache.commons.io.FileUtils.getUserDirectory();
    }

    public static String getUserDirectoryPath() {
        return org.apache.commons.io.FileUtils.getUserDirectoryPath();
    }

    public static void closeQuietly(Closeable closable) {
        if (null != closable) {
            try {
                closable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void listFiles(File file, Predicate<File> accept, Consumer<File> handle) {
        if (accept.test(file)) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (null != files) {
                    for (File f : files) {
                        FileUtils.listFiles(f, accept, handle);
                    }
                }
            } else {
                handle.accept(file);
            }
        }
    }

    public static String getResolvedPath(File path, String name) {
        File f = null != name && name.length() > 0 ? new File(path, name) : path;
        try {
            return f.getCanonicalPath();
        }
        catch (IOException e) {
            return f.getAbsolutePath();
        }
    }

    public static File getResolvedFile(File path) {
        try {
            return path.getCanonicalFile();
        }
        catch (IOException e) {
            return path.getAbsoluteFile();
        }
    }

    public static String fileToBase64(File file) throws IOException {
        byte[] fileContent = org.apache.commons.io.FileUtils.readFileToByteArray((File)file);
        return Base64.getEncoder().encodeToString(fileContent);
    }

    public static void base64ToFile(String string, File file) throws IOException {
        byte[] decodedBytes = Base64.getDecoder().decode(string);
        org.apache.commons.io.FileUtils.writeByteArrayToFile((File)file, (byte[])decodedBytes);
    }

    public static String sanitizeFileName(String str) {
        return str.replaceAll("[^a-zA-Z0-9-_\\.]", "_");
    }

    public static String sanitizeFileName(String str, boolean addTimestamp) {
        String tmp = addTimestamp ? str + "-" + System.currentTimeMillis() : str;
        return FileUtils.sanitizeFileName(tmp);
    }

    public static File findFile(File folder, String name) {
        Collection tmp = org.apache.commons.io.FileUtils.listFiles((File)folder, (IOFileFilter)FileFilterUtils.nameFileFilter((String)name), (IOFileFilter)TrueFileFilter.INSTANCE);
        Iterator iter = tmp.iterator();
        File result = iter.hasNext() ? (File)iter.next() : null;
        return result;
    }

    public static File getSystemRoot() {
        File result;
        if (OsUtils.isWindows()) {
            String sysDrive = System.getenv("SystemDrive");
            if (null == sysDrive) {
                sysDrive = "C:";
            }
            result = new File(sysDrive);
        } else {
            result = new File("/");
        }
        return result;
    }

    public static void write(File file, CharSequence data) throws IOException {
        FileUtils.write(file, data, Charset.defaultCharset());
    }

    public static void write(File file, CharSequence data, Charset charset) throws IOException {
        org.apache.commons.io.FileUtils.write((File)file, (CharSequence)data, (Charset)charset);
    }

    public static String readFileToString(File file) throws IOException {
        return org.apache.commons.io.FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
    }

    public static String readFileToString(File file, Charset charset) throws IOException {
        return org.apache.commons.io.FileUtils.readFileToString((File)file, (Charset)charset);
    }

    public static void deleteDirectory(File directory) throws IOException {
        org.apache.commons.io.FileUtils.deleteDirectory((File)directory);
    }

    public static void copyDirectory(File srcDir, File destDir, FileFilter filter) throws IOException {
        org.apache.commons.io.FileUtils.copyDirectory((File)srcDir, (File)destDir, (FileFilter)filter);
    }

    public static void copyDirectory(File srcDir, File destDir, FileFilter filter, boolean preserveFileDate) throws IOException {
        org.apache.commons.io.FileUtils.copyDirectory((File)srcDir, (File)destDir, (FileFilter)filter, (boolean)preserveFileDate);
    }

    public static void copyDirectory(File srcDir, File destDir) throws IOException {
        org.apache.commons.io.FileUtils.copyDirectory((File)srcDir, (File)destDir);
    }

    public static void copyFile(File srcFile, File destFile) throws IOException {
        org.apache.commons.io.FileUtils.copyFile((File)srcFile, (File)destFile);
    }

    public static void writeStringToFile(File file, String data) throws IOException {
        org.apache.commons.io.FileUtils.writeStringToFile((File)file, (String)data, (Charset)Charset.defaultCharset());
    }

    public static void writeStringToFile(File file, String data, Charset charset) throws IOException {
        org.apache.commons.io.FileUtils.writeStringToFile((File)file, (String)data, (Charset)charset);
    }

    public static byte[] readFileToByteArray(File file) throws IOException {
        return org.apache.commons.io.FileUtils.readFileToByteArray((File)file);
    }

    public static void writeByteArrayToFile(File file, byte[] data) throws IOException {
        org.apache.commons.io.FileUtils.writeByteArrayToFile((File)file, (byte[])data);
    }

    public static void writeByteArrayToFile(File file, byte[] data, boolean append) throws IOException {
        org.apache.commons.io.FileUtils.writeByteArrayToFile((File)file, (byte[])data, (boolean)append);
    }

    public static void copyInputStreamToFile(InputStream source, File destination) throws IOException {
        org.apache.commons.io.FileUtils.copyInputStreamToFile((InputStream)source, (File)destination);
    }

    public static boolean contentEquals(File file1, File file2) throws IOException {
        return org.apache.commons.io.FileUtils.contentEquals((File)file1, (File)file2);
    }
}

