/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.fasterxml.jackson.databind.module.SimpleAbstractTypeResolver;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.json.IOIterator;
import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.support.json.JsonIgnore;
import de.iip_ecosphere.platform.support.json.JsonIgnoreProperties;
import de.iip_ecosphere.platform.support.json.JsonProperty;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class JsonUtils {
    public static final SimpleAbstractTypeResolver IIP_TYPE_RESOLVER = new SimpleAbstractTypeResolver(){
        private static final long serialVersionUID = -3746467806797935401L;

        public JavaType findTypeMapping(DeserializationConfig config, JavaType type) {
            JavaType result = null;
            String className = type.getRawClass().getName();
            if (type.isInterface() && className.startsWith("iip.")) {
                String name = className + "Impl";
                try {
                    Class<?> cls = Class.forName(name);
                    result = config.getTypeFactory().constructType(cls);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            if (null == result) {
                result = super.findTypeMapping(config, type);
            }
            return result;
        }
    };
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static String toJson(Object obj) {
        String result = "";
        if (null != obj) {
            try {
                result = MAPPER.writeValueAsString(obj);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return result;
    }

    public static <R> R fromJson(Object json, Class<R> cls) {
        Object result = null;
        if (null != json) {
            try {
                result = MAPPER.readValue(json.toString(), cls);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return (R)result;
    }

    public <R> List<R> listFromJson(Object json, Class<R> cls) {
        return Json.listFromJsonDflt(json, cls);
    }

    public <K, V> Map<K, V> mapFromJson(Object json, Class<K> keyCls, Class<K> valueCls) {
        return Json.mapFromJsonDflt(json, keyCls, valueCls);
    }

    public static String escape(String input) {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char ch;
            char chx = ch = input.charAt(i);
            assert (chx != '\u0000');
            if (ch == '\n') {
                output.append("\\n");
                continue;
            }
            if (ch == '\t') {
                output.append("\\t");
                continue;
            }
            if (ch == '\r') {
                output.append("\\r");
                continue;
            }
            if (ch == '\\') {
                output.append("\\\\");
                continue;
            }
            if (ch == '\"') {
                output.append("\\\"");
                continue;
            }
            if (ch == '\b') {
                output.append("\\b");
                continue;
            }
            if (ch == '\f') {
                output.append("\\f");
                continue;
            }
            if (chx >= '\u10000') {
                assert (false) : "Java stores as u16, so it should never give us a character that's bigger than 2 bytes. It literally can't.";
                continue;
            }
            if (chx > '\u007f') {
                output.append(String.format("\\u%04x", chx));
                continue;
            }
            output.append(ch);
        }
        return output.toString();
    }

    public static String unescape(String input) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < input.length()) {
            char delimiter = input.charAt(i);
            if (delimiter == '\\' && ++i < input.length()) {
                char ch = input.charAt(i);
                ++i;
                if (ch == '\\' || ch == '/' || ch == '\"' || ch == '\'') {
                    builder.append(ch);
                    continue;
                }
                if (ch == 'n') {
                    builder.append('\n');
                    continue;
                }
                if (ch == 'r') {
                    builder.append('\r');
                    continue;
                }
                if (ch == 't') {
                    builder.append('\t');
                    continue;
                }
                if (ch == 'b') {
                    builder.append('\b');
                    continue;
                }
                if (ch == 'f') {
                    builder.append('\f');
                    continue;
                }
                if (ch == 'u') {
                    StringBuilder hex = new StringBuilder();
                    if (i + 4 > input.length()) {
                        throw new RuntimeException("Not enough unicode digits! ");
                    }
                    for (char x : input.substring(i, i + 4).toCharArray()) {
                        if (!Character.isLetterOrDigit(x)) {
                            throw new RuntimeException("Bad character in unicode escape.");
                        }
                        hex.append(Character.toLowerCase(x));
                    }
                    i += 4;
                    int code = Integer.parseInt(hex.toString(), 16);
                    builder.append((char)code);
                    continue;
                }
                throw new RuntimeException("Illegal escape sequence: \\" + ch);
            }
            builder.append(delimiter);
        }
        return builder.toString();
    }

    public static ObjectMapper configureFor(ObjectMapper mapper, Class<?> cls) {
        JsonIgnoreProperties annIgnoreProp = cls.getAnnotation(JsonIgnoreProperties.class);
        HashSet<String> ignores = new HashSet<String>();
        HashMap<String, String> renames = new HashMap<String, String>();
        boolean ignoreCls = false;
        if (null != annIgnoreProp && annIgnoreProp.ignoreUnknown()) {
            ignoreCls = true;
        }
        for (Field field : cls.getDeclaredFields()) {
            JsonUtils.handleAnnotations(field.getName(), field, ignores, renames);
        }
        for (AccessibleObject accessibleObject : cls.getDeclaredMethods()) {
            String name = ((Method)accessibleObject).getName();
            if (name.length() > 3 && (name.startsWith("get") || name.startsWith("set"))) {
                name = name.substring(3);
            }
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            JsonUtils.handleAnnotations(name, accessibleObject, ignores, renames);
        }
        if (ignoreCls || ignores.size() > 0) {
            SimpleModule module = new SimpleModule();
            ignores = ignores.isEmpty() ? null : ignores;
            module.setSerializerModifier((BeanSerializerModifier)new CustomPropertyExclusionModifier(cls, ignores));
            mapper.registerModule((Module)module);
        }
        if (!renames.isEmpty()) {
            CustomPropertyNamingStrategy cpns;
            PropertyNamingStrategy pns = mapper.getPropertyNamingStrategy();
            if (pns instanceof CustomPropertyNamingStrategy) {
                cpns = (CustomPropertyNamingStrategy)pns;
            } else {
                cpns = new CustomPropertyNamingStrategy();
                mapper.setPropertyNamingStrategy((PropertyNamingStrategy)cpns);
            }
            cpns.addMapping(cls, renames);
        }
        return mapper;
    }

    private static void handleAnnotations(String propName, AccessibleObject obj, Set<String> ignores, Map<String, String> renames) {
        JsonIgnore annIgnore = obj.getAnnotation(JsonIgnore.class);
        JsonProperty annProp = obj.getAnnotation(JsonProperty.class);
        if (null != annIgnore && annIgnore.value()) {
            ignores.add(propName);
        }
        if (null != annProp && annProp.value() != null && annProp.value().length() > 0) {
            renames.put(propName, annProp.value());
        }
    }

    public static ObjectMapper handleIipDataClasses(ObjectMapper mapper) {
        SimpleModule iipModule = new SimpleModule();
        iipModule.setAbstractTypes(IIP_TYPE_RESOLVER);
        return mapper.registerModule((Module)iipModule);
    }

    public static ObjectMapper defineOptionals(ObjectMapper mapper, Class<?> cls, String ... fieldNames) {
        return mapper.addHandler((DeserializationProblemHandler)new OptionalFieldsDeserializationProblemHandler(cls, fieldNames));
    }

    public static ObjectMapper defineFields(ObjectMapper mapper, String ... fieldNames) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        for (String fn : fieldNames) {
            String javaField = fn;
            if (javaField.length() > 0) {
                javaField = Character.toUpperCase(javaField.charAt(0)) + javaField.substring(1);
            }
            mapping.put(javaField, fn);
        }
        return mapper.setPropertyNamingStrategy((PropertyNamingStrategy)new MappingPropertyNamingStrategy(mapping));
    }

    public static ObjectMapper exceptFields(ObjectMapper mapper, String ... fieldNames) {
        final Set<String> exclusions = CollectionUtils.addAll(new HashSet(), fieldNames);
        mapper.setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector(){
            private static final long serialVersionUID = -6485293464445674590L;

            public boolean hasIgnoreMarker(AnnotatedMember member) {
                return exclusions.contains(member.getName()) || super.hasIgnoreMarker(member);
            }
        });
        return mapper;
    }

    public static String toJson(ObjectMapper mapper, Object object) {
        String result = "";
        if (null != object) {
            try {
                result = mapper.writeValueAsString(object);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return result;
    }

    public static ObjectMapper declareEnums(ObjectMapper mapper, Json.EnumMapping<?> ... mappings) {
        SimpleModule module = new SimpleModule();
        for (Json.EnumMapping<?> m : mappings) {
            if (!(m instanceof JacksonEnumMapping)) continue;
            ((JacksonEnumMapping)m).addToModule(module);
        }
        return mapper.registerModule((Module)module);
    }

    public static ObjectMapper configureLazy(ObjectMapper mapper, final Set<Object> ignore) {
        mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.activateDefaultTyping((PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance, ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.WRAPPER_ARRAY);
        if (!ignore.isEmpty()) {
            mapper.setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector(){
                private static final long serialVersionUID = 7445592829151624983L;

                public boolean hasIgnoreMarker(AnnotatedMember member) {
                    return ignore.contains(member.getType().getRawClass()) || ignore.contains(member.getMember()) || super.hasIgnoreMarker(member);
                }
            });
        }
        return mapper;
    }

    public static <T> IOIterator<T> createIterator(ObjectMapper mapper, InputStream stream, final Class<T> cls) throws IOException {
        JsonFactory jf = new JsonFactory();
        final JsonParser jp = jf.createParser(stream);
        jp.setCodec((ObjectCodec)mapper);
        jp.nextToken();
        return new IOIterator<T>(){

            @Override
            public boolean hasNext() throws IOException {
                return jp.hasCurrentToken();
            }

            @Override
            public T next() throws IOException {
                Object data = jp.readValueAs(cls);
                jp.nextToken();
                return data;
            }
        };
    }

    public static class CustomPropertyExclusionModifier
    extends BeanSerializerModifier {
        private final Set<String> propertiesToExclude;
        private final Class<?> targetClass;

        public CustomPropertyExclusionModifier(Class<?> targetClass, String ... propertiesToExclude) {
            this(targetClass, new HashSet<String>(Arrays.asList(propertiesToExclude)));
        }

        public CustomPropertyExclusionModifier(Class<?> targetClass, Set<String> propertiesToExclude) {
            this.targetClass = targetClass;
            this.propertiesToExclude = propertiesToExclude;
        }

        public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
            if (beanDesc.getBeanClass() == this.targetClass) {
                ArrayList<BeanPropertyWriter> newProperties = new ArrayList<BeanPropertyWriter>();
                for (BeanPropertyWriter writer : beanProperties) {
                    if (this.propertiesToExclude == null || this.propertiesToExclude.contains(writer.getName())) continue;
                    newProperties.add(writer);
                }
                return newProperties;
            }
            return super.changeProperties(config, beanDesc, beanProperties);
        }
    }

    public static class CustomPropertyNamingStrategy
    extends PropertyNamingStrategy {
        private static final long serialVersionUID = -6610876934860406571L;
        private final Map<Class<?>, Map<String, String>> propertyRenameMap = new HashMap();

        public void addMapping(Class<?> cls, Map<String, String> mapping) {
            this.propertyRenameMap.put(cls, mapping);
        }

        private String getMapping(Class<?> cls, String defaultName, Supplier<String> fallback) {
            Map<String, String> mapping = this.propertyRenameMap.get(cls);
            if (null != mapping && mapping.containsKey(defaultName)) {
                return mapping.get(defaultName);
            }
            return fallback.get();
        }

        public String nameForField(MapperConfig<?> config, AnnotatedField field, String defaultName) {
            return this.getMapping(field.getDeclaringClass(), defaultName, () -> super.nameForField(config, field, defaultName));
        }

        public String nameForGetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
            return this.getMapping(method.getDeclaringClass(), defaultName, () -> super.nameForGetterMethod(config, method, defaultName));
        }

        public String nameForSetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
            return this.getMapping(method.getDeclaringClass(), defaultName, () -> super.nameForSetterMethod(config, method, defaultName));
        }

        public String nameForConstructorParameter(MapperConfig<?> config, AnnotatedParameter ctorParam, String defaultName) {
            return this.getMapping(ctorParam.getDeclaringClass(), defaultName, () -> super.nameForConstructorParameter(config, ctorParam, defaultName));
        }
    }

    public static class OptionalFieldsDeserializationProblemHandler
    extends DeserializationProblemHandler {
        private Class<?> cls;
        private Set<String> optionalFields = new HashSet<String>();

        public OptionalFieldsDeserializationProblemHandler(Class<?> cls, String ... fieldNames) {
            this.cls = cls;
            for (String f : fieldNames) {
                this.optionalFields.add(f);
            }
        }

        public boolean handleUnknownProperty(DeserializationContext ctxt, JsonParser parser, JsonDeserializer<?> deserializer, Object beanOrClass, String propertyName) throws IOException {
            boolean result = this.optionalFields.contains(propertyName) && beanOrClass.getClass().equals(this.cls);
            return result;
        }
    }

    public static class MappingPropertyNamingStrategy
    extends PropertyNamingStrategy {
        private static final long serialVersionUID = -3963175454099182994L;
        private PropertyNamingStrategy fallback;
        private Map<String, String> mapping;

        public MappingPropertyNamingStrategy(Map<String, String> mapping) {
            this(mapping, new PropertyNamingStrategy());
        }

        public MappingPropertyNamingStrategy(Map<String, String> mapping, PropertyNamingStrategy fallback) {
            this.fallback = fallback;
            this.mapping = mapping;
        }

        public String nameForConstructorParameter(MapperConfig<?> config, AnnotatedParameter ctorParam, String defaultName) {
            return this.fallback.nameForConstructorParameter(config, ctorParam, defaultName);
        }

        public String nameForField(MapperConfig<?> config, AnnotatedField field, String defaultName) {
            String result = field.getName();
            if (result == null) {
                result = this.fallback.nameForField(config, field, defaultName);
            }
            return result;
        }

        public String nameForGetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
            String result;
            String fieldName = method.getName();
            if (fieldName.startsWith("get")) {
                fieldName = fieldName.substring(3);
            }
            if ((result = this.mapping.get(fieldName)) == null) {
                result = this.fallback.nameForSetterMethod(config, method, defaultName);
            }
            return result;
        }

        public String nameForSetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
            String result;
            String fieldName = method.getName();
            if (fieldName.startsWith("set")) {
                fieldName = fieldName.substring(3);
            }
            if ((result = this.mapping.get(fieldName)) == null) {
                result = this.fallback.nameForSetterMethod(config, method, defaultName);
            }
            return result;
        }
    }

    public static class JacksonEnumMapping<T>
    implements Json.EnumMapping<T> {
        private Class<T> type;
        private Map<String, T> mapping = new HashMap<String, T>();

        public JacksonEnumMapping(Class<T> type) {
            this(type, null);
        }

        public JacksonEnumMapping(Class<T> type, Map<String, T> mapping) {
            this.type = type;
            if (null != mapping) {
                this.mapping.putAll(mapping);
            }
        }

        @Override
        public void addMapping(String name, T value) {
            this.mapping.put(name, value);
        }

        @Override
        public Class<T> getType() {
            return this.type;
        }

        public void addToModule(SimpleModule module) {
            module.addDeserializer(this.type, new EnumDeserializer<T>(this.mapping, this.type));
        }
    }

    public static class EnumDeserializer<T>
    extends StdDeserializer<T> {
        private static final long serialVersionUID = -1654499344527076310L;
        private Map<String, T> mapping;

        public EnumDeserializer(Map<String, T> mapping, Class<T> cls) {
            super(cls);
            this.mapping = mapping;
        }

        public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            T result = null;
            JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
            String name = node.asText();
            if (null != name) {
                result = this.mapping.get(name);
            }
            return result;
        }
    }
}

