/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.AtomicDouble;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.junit.Assert;
import org.junit.Test;

public class AtomicDoubleTest {
    @Test
    public void testDouble() throws IOException, ClassNotFoundException {
        AtomicDouble d = new AtomicDouble();
        Assert.assertEquals((double)0.0, (double)d.get(), (double)0.01);
        d = new AtomicDouble(2.0);
        Assert.assertEquals((double)2.0, (double)d.get(), (double)0.01);
        d.addAndGet(1.0);
        Assert.assertEquals((double)3.0, (double)d.get(), (double)0.01);
        Assert.assertEquals((double)3.0, (double)d.doubleValue(), (double)0.01);
        Assert.assertEquals((long)3L, (long)d.intValue());
        d.set(5.0);
        Assert.assertEquals((double)5.0, (double)d.doubleValue(), (double)0.01);
        Assert.assertEquals((Object)String.valueOf(5.0), (Object)d.toString());
        Assert.assertEquals((long)5L, (long)d.longValue());
        Assert.assertEquals((double)5.0, (double)d.floatValue(), (double)0.01);
        Assert.assertEquals((double)5.0, (double)d.getAndSet(10.0), (double)0.01);
        Assert.assertEquals((double)10.0, (double)d.get(), (double)0.01);
        Assert.assertEquals((double)10.0, (double)d.getAndAdd(10.0), (double)0.01);
        Assert.assertEquals((double)20.0, (double)d.get(), (double)0.01);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutputStream oOut = new ObjectOutputStream(out);
        oOut.writeObject(d);
        oOut.close();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        ObjectInputStream oIn = new ObjectInputStream(in);
        Object obj = oIn.readObject();
        oIn.close();
        Assert.assertTrue((boolean)(obj instanceof AtomicDouble));
        AtomicDouble d2 = (AtomicDouble)obj;
        Assert.assertEquals((double)d.get(), (double)d2.get(), (double)0.01);
        Assert.assertEquals((Object)d, (Object)d);
        Assert.assertEquals((long)d.hashCode(), (long)d.hashCode());
        d.compareAndSet(20.0, 21.0);
        d.lazySet(22.0);
        d.weakCompareAndSet(22.0, 23.0);
    }
}

