/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.support.json.JsonArray;
import de.iip_ecosphere.platform.support.json.JsonNumber;
import de.iip_ecosphere.platform.support.json.JsonObject;
import de.iip_ecosphere.platform.support.json.JsonString;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class JsonTest {
    private void assertData(Data value, Data expected) {
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((long)value.getiValue(), (long)expected.getiValue());
        Assert.assertEquals((Object)value.getsValue(), (Object)expected.getsValue());
    }

    @Test
    public void testJson() throws IOException {
        Json json = Json.createInstance();
        Data data = new Data();
        data.setiValue(10);
        data.setsValue("abba");
        String s = Json.toJsonDflt((Object)data);
        Data data1 = (Data)Json.fromJsonDflt((Object)s, Data.class);
        this.assertData(data1, data);
        s = json.toJson((Object)data);
        data1 = (Data)json.fromJson((Object)s, Data.class);
        this.assertData(data1, data);
        byte[] b = json.writeValueAsBytes((Object)data);
        data1 = (Data)json.readValue(b, Data.class);
        this.assertData(data1, data);
    }

    @Test
    public void testJsonObject() throws IOException {
        JsonObject jobj = (JsonObject)Json.createObjectBuilder().add("intVal", 1).add("strVal", "abc").add("boolVal", true).add("dblVal", 2.0).add("arr", (JsonArray)Json.createArrayBuilder().add(1).add("str").add(true).add(Json.createArrayBuilder()).build()).build();
        String json = jobj.toString();
        JsonObject obj = Json.createObject((String)json);
        Assert.assertNotNull((Object)obj);
        JsonNumber n1 = obj.getJsonNumber("intVal");
        Assert.assertNotNull((Object)n1);
        Assert.assertEquals((long)1L, (long)n1.intValue());
        JsonNumber n2 = obj.getJsonNumber("dblVal");
        Assert.assertNotNull((Object)n2);
        Assert.assertEquals((double)2.0, (double)n2.intValue(), (double)0.01);
        JsonString s1 = obj.getJsonString("strVal");
        Assert.assertNotNull((Object)s1);
        Assert.assertEquals((Object)"abc", (Object)s1.getString());
        Assert.assertEquals((long)1L, (long)obj.getInt("intVal"));
        Assert.assertEquals((Object)"abc", (Object)obj.getString("strVal"));
        Assert.assertEquals((Object)true, (Object)obj.getBoolean("boolVal"));
        JsonArray a1 = obj.getJsonArray("arr");
        Assert.assertEquals((long)4L, (long)a1.size());
        Assert.assertNotNull((Object)a1);
        Assert.assertEquals((Object)"str", (Object)a1.getString(1));
        Assert.assertEquals((long)1L, (long)a1.getInt(0));
        Assert.assertEquals((Object)true, (Object)a1.getBoolean(2));
        JsonArray a2 = a1.getJsonArray(3);
        Assert.assertNotNull((Object)a2);
        Assert.assertEquals((long)0L, (long)a2.size());
    }

    @Test
    public void testJsonIter() throws IOException {
        Json.parse((byte[])new byte[0]);
        Json.parse((String)"");
    }

    public static class Data {
        private int iValue;
        private String sValue;

        public int getiValue() {
            return this.iValue;
        }

        public void setiValue(int iValue) {
            this.iValue = iValue;
        }

        public String getsValue() {
            return this.sValue;
        }

        public void setsValue(String sValue) {
            this.sValue = sValue;
        }
    }
}

