/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.Version;
import org.junit.Assert;
import org.junit.Test;

public class VersionTest {
    @Test
    public void versionFormatExc() {
        try {
            Version ver = new Version("a");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"ais not valid", (Object)e.getMessage());
        }
    }

    @Test
    public void versionTests() {
        new Version((String)null);
        new Version(new int[0]);
        new Version((int[])null);
        Version v0 = new Version(new int[]{0});
        Version v101 = new Version("1.0.1");
        Version v1011 = new Version("1.0.1.1");
        Version v102 = new Version(new int[]{1, 0, 2});
        Version a0 = new Version(new int[]{0});
        Assert.assertEquals((long)0L, (long)v0.compareTo(v0));
        Assert.assertEquals((long)-1L, (long)v0.compareTo(v101));
        Assert.assertEquals((long)1L, (long)v102.compareTo(v101));
        Assert.assertEquals((long)0L, (long)Version.compare((Version)v0, (Version)v0));
        Assert.assertEquals((long)-1L, (long)Version.compare((Version)v0, (Version)v101));
        Assert.assertEquals((long)1L, (long)Version.compare((Version)v102, (Version)v101));
        Assert.assertEquals((long)-1L, (long)Version.compare((Version)v101, (Version)v1011));
        Assert.assertEquals((long)1L, (long)Version.compare((Version)v1011, (Version)v101));
        Assert.assertEquals((long)0L, (long)Version.compare(null, null));
        Assert.assertEquals((long)-1L, (long)Version.compare(null, (Version)v0));
        Assert.assertEquals((long)1L, (long)Version.compare((Version)v0, null));
        Assert.assertNotEquals((long)v0.hashCode(), (long)v102.hashCode());
        Assert.assertNotEquals((Object)v0, (Object)v102);
        Assert.assertEquals((Object)v0, (Object)v0);
        Assert.assertEquals((Object)v0, (Object)a0);
        Assert.assertFalse((boolean)Version.equals((Version)v0, (Version)v102));
        Assert.assertFalse((boolean)Version.equals((Version)v0, null));
        Assert.assertFalse((boolean)Version.equals(null, (Version)v0));
        Assert.assertTrue((boolean)Version.equals(null, null));
        Assert.assertTrue((boolean)Version.equals((Version)v0, (Version)v0));
        Assert.assertTrue((boolean)Version.equals((Version)v0, (Version)a0));
        Assert.assertFalse((boolean)Version.isVersion(null));
        Assert.assertFalse((boolean)Version.isVersion((String)"0.-1"));
        Assert.assertFalse((boolean)Version.isVersion((String)"a"));
        Assert.assertTrue((boolean)Version.isVersion((String)"0"));
        Assert.assertTrue((boolean)Version.isVersion((String)"0.1"));
        Assert.assertEquals((Object)"0", (Object)v0.toString());
        Assert.assertEquals((Object)"1.0.1", (Object)v101.toString());
        Assert.assertEquals((Object)"1.0.2", (Object)v102.toString());
    }
}

