/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.logging;

import de.iip_ecosphere.platform.support.logging.FallbackLogger;
import de.iip_ecosphere.platform.support.logging.LogLevel;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;

public class FallbackLoggerTest {
    @Test
    public void testAbbreviate() {
        Assert.assertEquals((Object)"Class", (Object)FallbackLogger.abbreviate((String)"Class"));
        Assert.assertEquals((Object)"a.b.c.Class", (Object)FallbackLogger.abbreviate((String)"a.b.c.Class"));
        Assert.assertEquals((Object)"a.b.c.Class", (Object)FallbackLogger.abbreviate((String)"alpha.beta.charly.Class"));
        Assert.assertEquals((Object)"a.Class", (Object)FallbackLogger.abbreviate((String)"alpha.Class"));
        Assert.assertEquals((Object)".Class", (Object)FallbackLogger.abbreviate((String)".Class"));
        Assert.assertEquals((Object)".", (Object)FallbackLogger.abbreviate((String)"."));
        Assert.assertEquals((Object)("t.d.i.p.s.l." + this.getClass().getSimpleName()), (Object)FallbackLogger.abbreviate((String)this.getClass().getName()));
    }

    @Test
    public void testLogger() {
        FallbackLogger logger = new FallbackLogger("cls");
        logger.setLevel(LogLevel.INFO);
        AtomicReference rcvLevel = new AtomicReference();
        AtomicReference rcvName = new AtomicReference();
        AtomicReference rcvMsg = new AtomicReference();
        AtomicReference rcvThrowable = new AtomicReference();
        logger.setEmitter((lvl, name, msg, th, out) -> {
            rcvLevel.set(lvl);
            rcvName.set(name);
            rcvMsg.set(msg);
            rcvThrowable.set(th);
        });
        String add = "";
        String msg2 = "Startup completed.";
        logger.info("{}{}", (Object)"Startup completed.", (Object)add);
        Assert.assertEquals((Object)"Startup completed.", rcvMsg.get());
        add = " Running until Ctrl-C.";
        logger.info("{}{}", (Object)"Startup completed.", (Object)add);
        Assert.assertEquals((Object)("Startup completed." + add), rcvMsg.get());
    }
}

