/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.logging;

import de.iip_ecosphere.platform.support.logging.FallbackLogger;
import de.iip_ecosphere.platform.support.logging.ILoggerFactory;
import de.iip_ecosphere.platform.support.logging.LogLevel;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactoryDescriptor;
import de.iip_ecosphere.platform.support.plugins.PluginManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class LoggerFactory {
    private static final LogLevel LEVEL = LogLevel.getDefault();
    private static Map<String, Logger> loggers = Collections.synchronizedMap(new HashMap());
    private static final ILoggerFactory FALLBACK_FACTORY;
    private static ILoggerFactory factory;

    public static void considerPlugin() {
        ILoggerFactory f = PluginManager.getPluginInstance(ILoggerFactory.class, LoggerFactoryDescriptor.class);
        if (null != f) {
            factory = f;
            loggers.clear();
            System.out.println("Using logger factory " + factory.getClass().getName());
        }
    }

    public static void setLoggerFactory(ILoggerFactory fcty) {
        if (null != fcty) {
            factory = fcty;
        }
    }

    public static Logger getLogger(String name) {
        Logger result;
        if (null == name) {
            name = "ROOT";
        }
        if (null == (result = loggers.get(name))) {
            result = factory.createLogger(name);
            loggers.put(name, result);
        }
        return result;
    }

    public static Logger getLogger(Class<?> cls) {
        return LoggerFactory.getLogger(cls == null ? null : cls.getName());
    }

    public static Logger getLogger(Object object) {
        Class<?> cls = object instanceof Class ? (Class<?>)object : (null == object ? null : object.getClass());
        return LoggerFactory.getLogger(cls);
    }

    static {
        factory = FALLBACK_FACTORY = new ILoggerFactory(){

            @Override
            public Logger createLogger(String name) {
                FallbackLogger logger = new FallbackLogger(name);
                logger.setLevel(LEVEL);
                return logger;
            }
        };
        LoggerFactory.considerPlugin();
    }
}

