/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.metrics;

import de.iip_ecosphere.platform.support.metrics.Clock;
import de.iip_ecosphere.platform.support.metrics.Counter;
import de.iip_ecosphere.platform.support.metrics.Gauge;
import de.iip_ecosphere.platform.support.metrics.Measurement;
import de.iip_ecosphere.platform.support.metrics.Meter;
import de.iip_ecosphere.platform.support.metrics.MeterFilter;
import de.iip_ecosphere.platform.support.metrics.MeterRegistry;
import de.iip_ecosphere.platform.support.metrics.MetricsFactoryProviderDescriptor;
import de.iip_ecosphere.platform.support.metrics.Statistic;
import de.iip_ecosphere.platform.support.metrics.Tag;
import de.iip_ecosphere.platform.support.metrics.Timer;
import de.iip_ecosphere.platform.support.plugins.PluginManager;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;

public abstract class MetricsFactory {
    private static MetricsFactory instance = PluginManager.getPluginInstance(MetricsFactory.class, MetricsFactoryProviderDescriptor.class);

    public static MetricsFactory getInstance() {
        return instance;
    }

    public static void setInstance(MetricsFactory rest) {
        if (null != rest) {
            instance = rest;
        }
    }

    public MeterRegistry createRegistry() {
        return this.createRegistry(null, false);
    }

    public MeterRegistry createRegistry(Object registry) {
        return this.createRegistry(registry, true);
    }

    protected abstract MeterRegistry createRegistry(Object var1, boolean var2);

    public abstract Counter.CounterBuilder createCounter(String var1);

    public abstract Timer.TimerBuilder createTimer(String var1);

    public abstract <T> Gauge.GaugeBuilder<T> createGauge(String var1, T var2, ToDoubleFunction<T> var3);

    public abstract Gauge.GaugeBuilder<Supplier<Number>> createGauge(String var1, Supplier<Number> var2);

    public abstract MeterFilter createFilterDenyNameStartsWith(String var1);

    public abstract MeterFilter createFilterAcceptNameStartsWith(String var1);

    public abstract MeterFilter createFilterDeny();

    public abstract Tag createTag(String var1, String var2);

    public abstract Tag createImmutableTag(String var1, String var2);

    public abstract Meter.Id createId(String var1, List<Tag> var2, String var3, String var4, Meter.Type var5);

    public Timer.Sample createTimerStart() {
        return new Timer.DefaultSample(this.getSystemClock());
    }

    public abstract Clock getSystemClock();

    public abstract Measurement createMeasurement(Supplier<Double> var1, Statistic var2);

    public static Counter.CounterBuilder buildCounter(String name) {
        return MetricsFactory.getInstance().createCounter(name);
    }

    public static Timer.TimerBuilder buildTimer(String name) {
        return MetricsFactory.getInstance().createTimer(name);
    }

    public static <T> Gauge.GaugeBuilder<T> buildGauge(String name, T obj, ToDoubleFunction<T> supplier) {
        return MetricsFactory.getInstance().createGauge(name, obj, supplier);
    }

    public static Gauge.GaugeBuilder<Supplier<Number>> buildGauge(String name, Supplier<Number> supplier) {
        return MetricsFactory.getInstance().createGauge(name, supplier);
    }

    public static MeterFilter denyNameStartsWith(String prefix) {
        return MetricsFactory.getInstance().createFilterDenyNameStartsWith(prefix);
    }

    public static MeterFilter acceptNameStartsWith(String prefix) {
        return MetricsFactory.getInstance().createFilterAcceptNameStartsWith(prefix);
    }

    public static MeterFilter deny() {
        return MetricsFactory.getInstance().createFilterDeny();
    }

    public static Tag buildTag(String key, String value) {
        return MetricsFactory.getInstance().createTag(key, value);
    }

    public static Tag buildImmutableTag(String key, String value) {
        return MetricsFactory.getInstance().createImmutableTag(key, value);
    }

    public static Meter.Id buildId(String name, List<Tag> tags, String baseUnit, String description, Meter.Type type) {
        return MetricsFactory.getInstance().createId(name, tags, baseUnit, description, type);
    }

    public static Measurement buildMeasurement(Supplier<Double> valueFunction, Statistic statistic) {
        return MetricsFactory.getInstance().createMeasurement(valueFunction, statistic);
    }
}

