/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.resources.FolderResourceResolver;
import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;

public class ResourceLoaderTest {
    private static int myResolverCalled = 0;
    private static int myResolver2Called = 0;

    @Test
    public void testResolver() throws IOException {
        MyResolver2 res = new MyResolver2();
        ResourceLoader.registerResourceResolver((ResourceResolver)res);
        InputStream is = ResourceLoader.getResourceAsStream((String)"Logo.jpg", (ResourceResolver[])new ResourceResolver[0]);
        Assert.assertNotNull((Object)is);
        is = ResourceLoader.getResourceAsStream((String)"/Logo.jpg", (ResourceResolver[])new ResourceResolver[0]);
        Assert.assertNotNull((Object)is);
        is.close();
        Assert.assertTrue((myResolverCalled > 0 ? 1 : 0) != 0);
        Assert.assertTrue((myResolver2Called == 0 ? 1 : 0) != 0);
        is = ResourceLoader.getResourceAsStream((String)"BadBadFile.xyz", (ResourceResolver[])new ResourceResolver[0]);
        Assert.assertNull((Object)is);
        Assert.assertTrue((myResolverCalled > 0 ? 1 : 0) != 0);
        Assert.assertTrue((myResolver2Called > 0 ? 1 : 0) != 0);
        is = ResourceLoader.getAllRegisteredResolver((ResourceResolver[])new ResourceResolver[0]).resolve("Logo.jpg");
        Assert.assertNotNull((Object)is);
        is.close();
        new FolderResourceResolver();
        FolderResourceResolver fRes = new FolderResourceResolver("./src/test/resources/META-INF/services");
        ResourceResolver myResolver = ResourceLoader.getAllRegisteredResolver((ResourceResolver[])new ResourceResolver[]{fRes});
        is = myResolver.resolve("Logo.jpg");
        Assert.assertNotNull((Object)is);
        is.close();
        is = myResolver.resolve("de.iip_ecosphere.platform.support.resources.ResourceResolver");
        Assert.assertNotNull((Object)is);
        is.close();
        is = ResourceLoader.getResourceAsStream((String)"de.iip_ecosphere.platform.support.resources.ResourceResolver", (ResourceResolver[])new ResourceResolver[]{fRes});
        Assert.assertNotNull((Object)is);
        is.close();
        ResourceLoader.unregisterResourceResolver((ResourceResolver)res);
        is = ResourceLoader.MAVEN_RESOLVER.resolve("Logo.jpg");
        Assert.assertNotNull((Object)is);
        is.close();
    }

    @Test
    public void testPrependSlash() {
        Assert.assertEquals((Object)"/a", (Object)ResourceLoader.prependSlash((String)"a"));
        Assert.assertEquals((Object)"/a", (Object)ResourceLoader.prependSlash((String)"/a"));
        Assert.assertEquals((Object)"/", (Object)ResourceLoader.prependSlash((String)""));
    }

    public static class MyResolver2
    implements ResourceResolver {
        public InputStream resolve(ClassLoader loader, String resource) {
            myResolver2Called++;
            return null;
        }
    }

    public static class MyResolver
    implements ResourceResolver {
        public InputStream resolve(ClassLoader loader, String resource) {
            myResolverCalled++;
            return null;
        }
    }
}

