/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.commons;

import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.commons.Commons;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.joda.time.DateTime;

public class TestCommons
extends Commons {
    static final ToStringStyle SHORT_STRING_STYLE = new ShortStringToStringStyle();

    public void reverse(Object[] array) {
        ArrayUtils.reverse((Object[])array);
    }

    public void copyFields(Object source, Object target) throws ExecutionException {
        if (null != target && null != source) {
            try {
                BeanUtils.copyProperties((Object)target, (Object)source);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new ExecutionException(e);
            }
        }
    }

    public final String escapeJava(String input) {
        return StringEscapeUtils.escapeJava((String)input);
    }

    public final String unescapeJava(String input) {
        return StringEscapeUtils.unescapeJava((String)input);
    }

    public String escapeJson(String input) {
        return StringEscapeUtils.escapeJson((String)input);
    }

    public String unescapeJson(String input) {
        return StringEscapeUtils.unescapeJson((String)input);
    }

    public <T extends CharSequence> T defaultIfBlank(T str, T defaultStr) {
        return (T)StringUtils.defaultIfBlank(str, defaultStr);
    }

    public <T extends CharSequence> T defaultIfEmpty(T str, T defaultStr) {
        return (T)StringUtils.defaultIfEmpty(str, defaultStr);
    }

    public boolean isBlank(CharSequence cs) {
        return StringUtils.isBlank((CharSequence)cs);
    }

    public boolean isNotBlank(CharSequence cs) {
        return StringUtils.isNotBlank((CharSequence)cs);
    }

    public String replaceOnce(String text, String searchString, String replacement) {
        return StringUtils.replaceOnce((String)text, (String)searchString, (String)replacement);
    }

    public boolean isEmpty(CharSequence cs) {
        return StringUtils.isEmpty((CharSequence)cs);
    }

    public String toString(Object obj) {
        return ReflectionToStringBuilder.toString((Object)obj);
    }

    public String toStringShortStyle(Object obj) {
        return ReflectionToStringBuilder.toString((Object)obj, (ToStringStyle)SHORT_STRING_STYLE);
    }

    public String removeStart(String str, String remove) {
        return StringUtils.removeStart((String)str, (String)remove);
    }

    public String removeEnd(String str, String remove) {
        return StringUtils.removeEnd((String)str, (String)remove);
    }

    public String getUserHome() {
        return SystemUtils.USER_HOME;
    }

    public boolean isWindows() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    public boolean isLinux() {
        return SystemUtils.IS_OS_LINUX;
    }

    public boolean isUnix() {
        return SystemUtils.IS_OS_UNIX;
    }

    public boolean isMac() {
        return SystemUtils.IS_OS_MAC;
    }

    public boolean isJava1_8() {
        return SystemUtils.IS_JAVA_1_8;
    }

    public File getJavaHome() {
        return SystemUtils.getJavaHome();
    }

    public String getJavaSpecificationVersion() {
        return SystemUtils.JAVA_SPECIFICATION_VERSION;
    }

    public boolean isIpV4Addess(String address) {
        return InetAddressValidator.getInstance().isValidInet4Address(address);
    }

    public String toString(InputStream in, Charset charset) throws IOException {
        return IOUtils.toString((InputStream)in, (Charset)charset);
    }

    public List<String> readLines(InputStream in, Charset charset) throws IOException {
        try {
            return IOUtils.readLines((InputStream)in, (Charset)charset);
        }
        catch (UncheckedIOException e) {
            throw new IOException(e);
        }
    }

    public boolean deleteQuietly(File file) {
        return FileUtils.deleteQuietly((File)file);
    }

    public void forceDelete(File file) throws IOException {
        FileUtils.forceDelete((File)file);
    }

    public void deleteOnExit(File file) {
        try {
            if (null != file) {
                FileUtils.forceDeleteOnExit((File)file);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getTempDirectoryPath() {
        return FileUtils.getTempDirectoryPath();
    }

    public File getTempDirectory() {
        return FileUtils.getTempDirectory();
    }

    public File getUserDirectory() {
        return FileUtils.getUserDirectory();
    }

    public String getUserDirectoryPath() {
        return FileUtils.getUserDirectoryPath();
    }

    public String fileToBase64(File file) throws IOException {
        byte[] fileContent = FileUtils.readFileToByteArray((File)file);
        return Base64.getEncoder().encodeToString(fileContent);
    }

    public void base64ToFile(String string, File file) throws IOException {
        byte[] decodedBytes = Base64.getDecoder().decode(string);
        FileUtils.writeByteArrayToFile((File)file, (byte[])decodedBytes);
    }

    public File findFile(File folder, String name) {
        Collection tmp = FileUtils.listFiles((File)folder, (IOFileFilter)FileFilterUtils.nameFileFilter((String)name), (IOFileFilter)TrueFileFilter.INSTANCE);
        Iterator iter = tmp.iterator();
        File result = iter.hasNext() ? (File)iter.next() : null;
        return result;
    }

    public void write(File file, CharSequence data, Charset charset) throws IOException {
        FileUtils.write((File)file, (CharSequence)data, (Charset)charset);
    }

    public String readFileToString(File file) throws IOException {
        return FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
    }

    public String readFileToString(File file, Charset charset) throws IOException {
        return FileUtils.readFileToString((File)file, (Charset)charset);
    }

    public void deleteDirectory(File directory) throws IOException {
        FileUtils.deleteDirectory((File)directory);
    }

    public void copyDirectory(File srcDir, File destDir, FileFilter filter) throws IOException {
        FileUtils.copyDirectory((File)srcDir, (File)destDir, (FileFilter)filter);
    }

    public void copyDirectory(File srcDir, File destDir, FileFilter filter, boolean preserveFileDate) throws IOException {
        FileUtils.copyDirectory((File)srcDir, (File)destDir, (FileFilter)filter, (boolean)preserveFileDate);
    }

    public void copyDirectory(File srcDir, File destDir) throws IOException {
        FileUtils.copyDirectory((File)srcDir, (File)destDir);
    }

    public void copyFile(File srcFile, File destFile) throws IOException {
        FileUtils.copyFile((File)srcFile, (File)destFile);
    }

    public void writeStringToFile(File file, String data) throws IOException {
        FileUtils.writeStringToFile((File)file, (String)data, (Charset)Charset.defaultCharset());
    }

    public void writeStringToFile(File file, String data, Charset charset) throws IOException {
        FileUtils.writeStringToFile((File)file, (String)data, (Charset)charset);
    }

    public byte[] readFileToByteArray(File file) throws IOException {
        return FileUtils.readFileToByteArray((File)file);
    }

    public void writeByteArrayToFile(File file, byte[] data) throws IOException {
        FileUtils.writeByteArrayToFile((File)file, (byte[])data);
    }

    public void writeByteArrayToFile(File file, byte[] data, boolean append) throws IOException {
        FileUtils.writeByteArrayToFile((File)file, (byte[])data, (boolean)append);
    }

    public void copyInputStreamToFile(InputStream source, File destination) throws IOException {
        FileUtils.copyInputStreamToFile((InputStream)source, (File)destination);
    }

    public boolean contentEquals(File file1, File file2) throws IOException {
        return FileUtils.contentEquals((File)file1, (File)file2);
    }

    public void registerDateConverters() {
        TimeUtils.registerConverter((TimeUtils.DateConverter)new TimeUtils.AbstractDateConverter<DateTime>(DateTime.class){

            public Date toDate(DateTime data) {
                return data.toDate();
            }
        });
    }

    private static final class ShortStringToStringStyle
    extends ToStringStyle {
        private static final long serialVersionUID = 1L;

        ShortStringToStringStyle() {
            this.setUseShortClassName(true);
            this.setUseIdentityHashCode(false);
        }

        public void append(StringBuffer buffer, String fieldName, Object value, Boolean fullDetail) {
            String sVal;
            if (value instanceof String && (sVal = (String)value).length() > 20) {
                value = sVal.substring(0, 20) + "...";
            }
            super.append(buffer, fieldName, value, fullDetail);
        }

        private Object readResolve() {
            return SHORT_STRING_STYLE;
        }
    }
}

