/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support;

import org.apache.commons.lang3.SystemUtils;

public class OsUtils {
    private OsUtils() {
    }

    public static final String getUserHome() {
        return SystemUtils.USER_HOME;
    }

    public static final String getOsName() {
        return System.getProperty("os.name", "");
    }

    public static final String getOsArch() {
        return System.getProperty("os.arch", "");
    }

    public static final int getNumCpuCores() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static String getEnv(String key) {
        String result = System.getenv(key);
        if (null == result) {
            result = System.getenv(key.toUpperCase().replace('.', '_'));
        }
        return result;
    }

    public static String getPropertyOrEnv(String key, String dflt) {
        String result = System.getProperty(key);
        if (null == result) {
            result = OsUtils.getEnv(key);
        }
        return null == result ? dflt : result;
    }

    public static boolean getBooleanPropertyOrEnv(String key, boolean dflt) {
        return Boolean.valueOf(OsUtils.getPropertyOrEnv(key, String.valueOf(dflt)));
    }

    public static String getPropertyOrEnv(String key) {
        return OsUtils.getPropertyOrEnv(key, null);
    }

    public static boolean isWindows() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    public static boolean isLinux() {
        return SystemUtils.IS_OS_LINUX;
    }

    public static boolean isUnix() {
        return SystemUtils.IS_OS_UNIX;
    }

    public static boolean isMac() {
        return SystemUtils.IS_OS_MAC;
    }

    public static boolean isJava1_8() {
        return SystemUtils.IS_JAVA_1_8;
    }
}

