/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.resources;

import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class FolderResourceResolver
implements ResourceResolver {
    public static final FolderResourceResolver SYSTEM_ROOT = new FolderResourceResolver();
    public static final FolderResourceResolver USER_HOME = new FolderResourceResolver(System.getProperty("user.home"));
    public static final FolderResourceResolver THIS_DIR = new FolderResourceResolver(".");
    private File basePath;
    private String removePrefix;

    public FolderResourceResolver() {
        this(FileUtils.getSystemRoot());
    }

    public FolderResourceResolver(String basePath) {
        this(new File(basePath));
    }

    public FolderResourceResolver(String basePath, String removePrefix) {
        this(new File(basePath), removePrefix);
    }

    public FolderResourceResolver(File basePath) {
        this(basePath, null);
    }

    public FolderResourceResolver(File basePath, String removePrefix) {
        this.basePath = basePath;
        this.removePrefix = removePrefix;
    }

    @Override
    public String getName() {
        return "Folder " + this.basePath;
    }

    @Override
    public InputStream resolve(ClassLoader loader, String resource) {
        if (null != this.removePrefix && this.removePrefix.length() > 0 && resource.startsWith(this.removePrefix)) {
            resource = resource.substring(this.removePrefix.length());
        }
        try {
            return new FileInputStream(new File(this.basePath, resource));
        }
        catch (IOException e) {
            return null;
        }
    }
}

