/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.yaml;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.yaml.Yaml;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class YamlFile {
    protected YamlFile() {
    }

    public static Object read(InputStream in) throws IOException {
        return Yaml.getInstance().load(in);
    }

    public static String asString(Object data, String dflt) {
        String result = null == data ? dflt : data.toString();
        return result;
    }

    public static Map<Object, Object> asMap(Object data) {
        HashMap<Object, Object> result = data instanceof Map ? (HashMap<Object, Object>)data : new HashMap<Object, Object>();
        return result;
    }

    public static List<Object> asList(Object data) {
        ArrayList<Object> result = data instanceof List ? (ArrayList<Object>)data : new ArrayList<Object>();
        return result;
    }

    public static Object getField(Object data, String ... field) {
        Object result = data;
        for (String f : field) {
            result = YamlFile.asMap(result).get(f);
        }
        return result;
    }

    public static Map<Object, Object> getFieldAsMap(Object data, String ... field) {
        return YamlFile.asMap(YamlFile.getField(data, field));
    }

    public static List<Object> getFieldAsList(Object data, String field) {
        return YamlFile.asList(YamlFile.getField(data, field));
    }

    public static String getFieldAsString(Object data, String field, String dflt) {
        return YamlFile.asString(YamlFile.getField(data, field), dflt);
    }

    public static <T> List<T> fixListSafe(List<T> list, Class<T> cls) {
        List<T> result = list;
        if (list != null) {
            try {
                result = YamlFile.fixList(list, cls);
            }
            catch (ExecutionException e) {
                LoggerFactory.getLogger(YamlFile.class).error(e.getMessage());
            }
        }
        return result;
    }

    public static <T> List<T> fixList(List<T> list, Class<T> cls) throws ExecutionException {
        ArrayList<T> result = new ArrayList<T>();
        for (int i = 0; i < list.size(); ++i) {
            T o = list.get(i);
            if (cls.isInstance(o)) {
                result.add(cls.cast(o));
                continue;
            }
            if (!(o instanceof HashMap)) continue;
            HashMap map = (HashMap)o;
            T s = YamlFile.createInstance(cls);
            for (Map.Entry e : map.entrySet()) {
                Field f = YamlFile.findField(cls, e.getKey().toString());
                if (f == null) continue;
                f.setAccessible(true);
                try {
                    f.set(s, e.getValue());
                }
                catch (IllegalAccessException | IllegalArgumentException e1) {
                    LoggerFactory.getLogger(YamlFile.class).error("Cannot set field {} on YamlServer: {}", (Object)f.getName(), (Object)e1.getMessage());
                }
            }
            result.add(s);
        }
        return result;
    }

    private static <T> T createInstance(Class<T> cls) throws ExecutionException {
        try {
            return cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new ExecutionException("Cannot create instanceo of type " + cls.getName() + ": " + e.getMessage(), e);
        }
    }

    public static Field findField(Class<?> cls, String name) {
        Field result;
        block2: {
            result = null;
            try {
                result = cls.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                if (cls.getSuperclass() == Object.class) break block2;
                result = YamlFile.findField(cls.getSuperclass(), name);
            }
        }
        return result;
    }

    public static Map<String, Object> getMap(Map<String, Object> yaml, String ... path) {
        Map result = null;
        for (String n : path) {
            Object tmp;
            if (null != yaml && (tmp = yaml.get(n)) instanceof Map) {
                result = (Map)tmp;
            }
            yaml = result;
        }
        return result;
    }

    public static <T> T overwrite(T obj, Class<T> cls, Map<String, Object> data) {
        ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Map myObjectMap = (Map)mapper.convertValue(obj, HashMap.class);
        data.forEach((k, v) -> YamlFile.map(k, v, myObjectMap));
        return (T)mapper.convertValue((Object)myObjectMap, cls);
    }

    private static void map(String key, Object value, Map<String, Object> target) {
        if (value instanceof Map && target.get(key) instanceof Map) {
            Map src = (Map)value;
            Map tgt = (Map)target.get(key);
            src.forEach((k, v) -> YamlFile.map(k, v, tgt));
        } else {
            target.merge(key, value, (v1, v2) -> v2);
        }
    }
}

