/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.IOUtils;
import de.iip_ecosphere.platform.support.ZipUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.junit.Assert;
import org.junit.Test;

public class ZipUtilsTest {
    @Test
    public void extractFullZip() throws IOException {
        File f = FileUtils.createTmpFolder((String)"support.jar");
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("test.zip");
        Assert.assertNotNull((Object)in);
        ZipUtils.extractZip((InputStream)in, (Path)f.toPath());
        ZipUtilsTest.assertFileExists(f, "text.txt", false);
        ZipUtilsTest.assertFileExists(f, "folder1", true);
        ZipUtilsTest.assertFileExists(f, "folder1/text11.txt", false);
        ZipUtilsTest.assertFileExists(f, "folder1/text12.txt", false);
        ZipUtilsTest.assertFileExists(f, "folder2", true);
        ZipUtilsTest.assertFileExists(f, "folder2/text21.txt", false);
        ZipUtilsTest.assertFileExists(f, "folder2/text22.txt", false);
        FileUtils.deleteQuietly((File)f);
    }

    private static void assertFileExists(File base, String name, boolean isDirectory) {
        File f = new File(base, name);
        Assert.assertTrue((String)(f.toString() + " does not exist"), (boolean)f.exists());
        if (isDirectory) {
            Assert.assertTrue((boolean)f.isDirectory());
        } else {
            Assert.assertTrue((boolean)f.isFile());
        }
    }

    private static void assertFileNotExists(File base, String name) {
        File f = new File(base, name);
        Assert.assertFalse((boolean)f.exists());
    }

    @Test
    public void extractPartialZip() throws IOException {
        File f = FileUtils.createTmpFolder((String)"support.jar");
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("test.zip");
        Assert.assertNotNull((Object)in);
        ZipUtils.extractZip((InputStream)in, (Path)f.toPath(), (Predicate)ZipUtils.inFolder((String)"folder1"));
        ZipUtilsTest.assertFileNotExists(f, "text.txt");
        ZipUtilsTest.assertFileExists(f, "folder1", true);
        ZipUtilsTest.assertFileExists(f, "folder1/text11.txt", false);
        ZipUtilsTest.assertFileExists(f, "folder1/text12.txt", false);
        ZipUtilsTest.assertFileNotExists(f, "folder2");
        ZipUtilsTest.assertFileNotExists(f, "folder2/text21.txt");
        ZipUtilsTest.assertFileNotExists(f, "folder2/text22.txt");
        FileUtils.deleteQuietly((File)f);
    }

    @Test
    public void extactFile() throws IOException {
        File f = FileUtils.createTmpFolder((String)"support.jar");
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("test.zip");
        InputStream fileStream = ZipUtils.findFile((InputStream)in, (String)"folder2/text21.txt");
        Assert.assertNotNull((Object)fileStream);
        String test = IOUtils.toString((InputStream)fileStream, (Charset)StandardCharsets.UTF_8);
        fileStream.close();
        Assert.assertEquals((Object)"text21.txt", (Object)test);
        FileUtils.closeQuietly((Closeable)in);
        in = this.getClass().getClassLoader().getResourceAsStream("test.zip");
        fileStream = ZipUtils.findFile((InputStream)in, (String)"folder2/text23.txt");
        Assert.assertNull((Object)fileStream);
        FileUtils.closeQuietly((Closeable)in);
        FileUtils.deleteQuietly((File)f);
    }

    @Test
    public void findFile() throws IOException {
        File f = new File("src/test/resources/test.zip");
        Assert.assertTrue((boolean)f.exists());
        InputStream fileStream = ZipUtils.findFile((File)f, (String)"folder2/text21.txt");
        Assert.assertNotNull((Object)fileStream);
        String test = IOUtils.toString((InputStream)fileStream, (Charset)StandardCharsets.UTF_8);
        fileStream.close();
        Assert.assertEquals((Object)"text21.txt", (Object)test);
        fileStream = ZipUtils.findFile((File)f, (String)"folder2/text23.txt");
        Assert.assertNull((Object)fileStream);
    }

    @Test
    public void testListFiles() throws IOException {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("test.zip");
        AtomicInteger fileCount = new AtomicInteger();
        AtomicInteger dirCount = new AtomicInteger();
        ZipUtils.listFiles((InputStream)in, z -> true, z -> {
            if (z.isDirectory()) {
                dirCount.incrementAndGet();
            } else {
                fileCount.incrementAndGet();
            }
        });
        FileUtils.closeQuietly((Closeable)in);
        Assert.assertEquals((long)5L, (long)fileCount.get());
        Assert.assertEquals((long)2L, (long)dirCount.get());
        fileCount.set(0);
        dirCount.set(0);
        in = this.getClass().getClassLoader().getResourceAsStream("test.zip");
        ZipUtils.listFiles((InputStream)in, z -> !z.isDirectory(), z -> {
            if (z.isDirectory()) {
                dirCount.incrementAndGet();
            } else {
                fileCount.incrementAndGet();
            }
        });
        FileUtils.closeQuietly((Closeable)in);
        Assert.assertEquals((long)5L, (long)fileCount.get());
        Assert.assertEquals((long)0L, (long)dirCount.get());
    }
}

