/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

public final class PidFile {
    public static final String PID_DIR_PROPERTY_NAME = "iip.pid.dir";
    private final long pid;
    private final Path path;
    private final boolean deleteOnExit;

    private PidFile(Path path, boolean deleteOnExit, long pid) throws IOException {
        this.path = path;
        this.deleteOnExit = deleteOnExit;
        this.pid = pid;
    }

    public static PidFile create(Path path, boolean deleteOnExit) throws IOException {
        return PidFile.create(path, deleteOnExit, PidFile.getJvmPid());
    }

    public static PidFile createInDefaultDir(String name, boolean deleteOnExit) throws IOException {
        return PidFile.createInDefaultDir(name, deleteOnExit, true);
    }

    public static String getPidDirectory() {
        return System.getProperty(PID_DIR_PROPERTY_NAME, FileUtils.getTempDirectoryPath());
    }

    public static PidFile createInDefaultDir(String name, boolean deleteOnExit, boolean deleteIfExists) throws IOException {
        File f = new File(PidFile.getPidDirectory(), name);
        if (deleteIfExists) {
            FileUtils.deleteQuietly((File)f);
        }
        return PidFile.create(f.toPath(), deleteOnExit);
    }

    static PidFile create(Path path, boolean deleteOnExit, long pid) throws IOException {
        Path parent = path.getParent();
        if (parent != null) {
            if (Files.exists(parent, new LinkOption[0]) && !Files.isDirectory(parent, new LinkOption[0])) {
                throw new IllegalArgumentException(parent + " exists but is not a directory");
            }
            if (!Files.exists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
        }
        if (Files.exists(path, new LinkOption[0]) && !Files.isRegularFile(path, new LinkOption[0])) {
            throw new IllegalArgumentException(path + " exists but is not a regular file");
        }
        try (OutputStream stream = Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            stream.write(Long.toString(pid).getBytes(StandardCharsets.UTF_8));
        }
        LoggerFactory.getLogger(PidFile.class).info("Created PID file " + path);
        if (deleteOnExit) {
            PidFile.addShutdownHook(path);
        }
        return new PidFile(path, deleteOnExit, pid);
    }

    public long getPid() {
        return this.pid;
    }

    public Path getPath() {
        return this.path;
    }

    public boolean isDeleteOnExit() {
        return this.deleteOnExit;
    }

    private static void addShutdownHook(final Path path) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(PidFile.class).error("Failed to delete PID file '{}': {}", (Object)path, (Object)e.getMessage());
                }
            }
        });
    }

    public static long getJvmPid() {
        long pid;
        String xPid = ManagementFactory.getRuntimeMXBean().getName();
        try {
            xPid = xPid.split("@")[0];
            pid = Long.parseLong(xPid);
        }
        catch (NumberFormatException e) {
            pid = -1L;
        }
        return pid;
    }
}

