/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.OsUtils;
import de.iip_ecosphere.platform.support.setup.AbstractSetup;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class AbstractSetupTest {
    @Test
    public void testSetup() throws IOException {
        String oldFName = AbstractSetup.setDefaultFileName((String)"iipecosphere-test.yml");
        try {
            Cfg.readFromYaml(Cfg.class, (String)"a");
            Assert.fail((String)"No exception, file does not exist");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Cfg2.readFromYaml(Cfg2.class, (String)"iipecosphere.yml");
            Assert.fail((String)"No exception, class cannot be instantiated");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Cfg cfg = (Cfg)((Object)Cfg.readFromYaml(Cfg.class, (String)AbstractSetup.getDefaultFileName()));
        Assert.assertNotNull((Object)((Object)cfg));
        Assert.assertEquals((long)42L, (long)cfg.getProperty());
        cfg = (Cfg)((Object)Cfg.readFromYaml(Cfg.class));
        Assert.assertNotNull((Object)((Object)cfg));
        Assert.assertEquals((long)42L, (long)cfg.getProperty());
        cfg = (Cfg)((Object)Cfg.readFromYaml(Cfg.class, (String)("/" + AbstractSetup.getDefaultFileName())));
        Assert.assertNotNull((Object)((Object)cfg));
        Assert.assertEquals((long)42L, (long)cfg.getProperty());
        cfg = (Cfg)((Object)Cfg.readFromYaml(Cfg.class, (String)"/iipecosphere-over.yml"));
        Assert.assertNotNull((Object)((Object)cfg));
        Assert.assertEquals((long)43L, (long)cfg.getProperty());
        AbstractSetup.setDefaultFileName((String)oldFName);
    }

    @Test
    public void testIsNotEmpty() {
        Assert.assertTrue((boolean)AbstractSetup.isNotEmpty((String)"a"));
        Assert.assertFalse((boolean)AbstractSetup.isNotEmpty((String)""));
        Assert.assertFalse((boolean)AbstractSetup.isNotEmpty(null));
    }

    @Test
    public void testPluginFolder() {
        String origProp = OsUtils.getPropertyOrEnv((String)"iip.plugins");
        Cfg cfg = new Cfg();
        Assert.assertEquals((Object)(null == origProp ? "plugins" : origProp), (Object)cfg.getPluginsFolder().toString());
        cfg = new Cfg();
        cfg.setPluginsFolder("test2");
        Assert.assertEquals((Object)"test2", (Object)cfg.getPluginsFolder().toString());
    }

    public static class Cfg
    extends AbstractSetup {
        private int property;

        public int getProperty() {
            return this.property;
        }

        public void setProperty(int property) {
            this.property = property;
        }
    }

    public static class Cfg2
    extends AbstractSetup {
        public Cfg2(String whatever) {
        }
    }
}

