/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.metrics;

import de.iip_ecosphere.platform.support.metrics.Clock;
import de.iip_ecosphere.platform.support.metrics.Meter;
import de.iip_ecosphere.platform.support.metrics.MetricsBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public interface Timer
extends Meter {
    public void record(Runnable var1);

    public void record(long var1, TimeUnit var3);

    public <T> T record(Supplier<T> var1);

    public <T> T recordCallable(Callable<T> var1) throws Exception;

    public long count();

    public TimeUnit baseTimeUnit();

    public double max(TimeUnit var1);

    public double totalTime(TimeUnit var1);

    public double mean(TimeUnit var1);

    public static class DefaultSample
    implements Sample {
        private final long startTime;
        private final Clock clock;

        DefaultSample(Clock clock) {
            this.clock = clock;
            this.startTime = clock.monotonicTime();
        }

        @Override
        public long stop(Timer timer) {
            long durationNs = this.clock.monotonicTime() - this.startTime;
            timer.record(durationNs, TimeUnit.NANOSECONDS);
            return durationNs;
        }
    }

    public static interface Sample {
        public long stop(Timer var1);
    }

    public static interface TimerBuilder
    extends MetricsBuilder<Timer, TimerBuilder> {
    }
}

