/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.setup;

import de.iip_ecosphere.platform.support.OsUtils;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.resources.FolderResourceResolver;
import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import de.iip_ecosphere.platform.support.setup.AbstractSetup;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class InstalledDependenciesSetup
extends AbstractSetup {
    public static final String PROPERTY_PATH = "iip.installedDeps";
    public static final String DEFAULT_NAME = "installedDependencies";
    public static final String DEFAULT_FNAME = "installedDependencies.yml";
    public static final String KEY_PREFIX_JAVA = "JAVA";
    public static final String KEY_PREFIX_PYTHON = "PYTHON";
    public static final String KEY_PREFIX_CONDA = "CONDA";
    public static final String KEY_JAVA_8 = "JAVA8";
    public static final String KEY_JAVA_11 = "JAVA11";
    private static InstalledDependenciesSetup instance;
    private Map<String, File> locations = new HashMap<String, File>();
    private Map<String, String> envMappings = new HashMap<String, String>();

    public InstalledDependenciesSetup() {
        this.setupDefaults();
    }

    private void setupDefaults() {
        String exeSuffix = "";
        if (OsUtils.isWindows()) {
            exeSuffix = ".exe";
        }
        File javaPath = new File(OsUtils.getJavaHome(), "bin/java" + exeSuffix);
        this.addDefaultEntry(InstalledDependenciesSetup.getJavaKey(), javaPath);
        this.addDefaultEntry(KEY_PREFIX_JAVA, javaPath);
        this.addDefaultEntry(KEY_PREFIX_PYTHON, new File("python"));
        this.addDefaultEntry(KEY_PREFIX_CONDA, new File("conda"));
    }

    private void addDefaultEntry(String key, File value) {
        if (!this.locations.containsKey(key)) {
            this.locations.put(key, value);
        }
    }

    public static String getJavaKey() {
        String ver = OsUtils.getJavaSpecificationVersion();
        if (ver.startsWith("1.")) {
            ver = ver.substring(2);
        }
        return KEY_PREFIX_JAVA + ver;
    }

    public Map<String, File> getLocations() {
        return this.locations;
    }

    public File getLocation(String key) {
        return null == key ? null : this.locations.get(key);
    }

    public String getEnvironmentMapping(String key, String dflt) {
        String env;
        String result = dflt;
        if (null != key && null != (env = this.envMappings.get(key))) {
            result = env;
        }
        return result;
    }

    public void setLocations(Map<String, File> locations) {
        this.locations = locations;
        this.setupDefaults();
    }

    public void setEnvMappings(Map<String, String> envMappings) {
        this.envMappings = envMappings;
    }

    public void setLocation(String key, File location) {
        this.locations.put(key, location);
        this.setupDefaults();
    }

    public static InstalledDependenciesSetup readFromYaml(String fileName) {
        InstalledDependenciesSetup result = null;
        InputStream in = ResourceLoader.getResourceAsStream((String)fileName, (ResourceResolver[])new ResourceResolver[]{new FolderResourceResolver(System.getProperty(PROPERTY_PATH, ".")), new FolderResourceResolver()});
        if (null != in) {
            try {
                result = InstalledDependenciesSetup.readFromYaml(InstalledDependenciesSetup.class, in);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(InstalledDependenciesSetup.class).warn("Cannot read '{}': {}. Falling back to default instance", (Object)fileName, (Object)e.getMessage());
            }
        }
        if (null == result) {
            result = new InstalledDependenciesSetup();
        }
        return result;
    }

    public static InstalledDependenciesSetup readFromYaml() {
        return InstalledDependenciesSetup.readFromYaml(DEFAULT_FNAME);
    }

    public static InstalledDependenciesSetup getInstance() {
        if (null == instance) {
            instance = InstalledDependenciesSetup.readFromYaml();
        }
        return instance;
    }

    public static File location(String key) throws ExecutionException {
        File location = InstalledDependenciesSetup.getInstance().getLocation(key);
        if (null == location) {
            throw new ExecutionException("No installed dependency for key '" + key + "'", null);
        }
        return location;
    }
}

