/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import org.junit.Assert;
import org.junit.Test;

public class SchemaServerEndpointTest {
    @Test
    public void testSchema() {
        Assert.assertEquals((Object)"http://", (Object)Schema.HTTP.toUri());
        Assert.assertFalse((boolean)Schema.HTTP.isEncrypted());
    }

    @Test
    public void testServerAddress() {
        Assert.assertTrue((boolean)ServerAddress.isValidPort((int)0));
        Assert.assertTrue((boolean)ServerAddress.isValidPort((int)8080));
        Assert.assertFalse((boolean)ServerAddress.isValidPort((int)-1));
        Assert.assertFalse((boolean)ServerAddress.isValidPort((int)66000));
        Assert.assertEquals((long)0L, (long)ServerAddress.validatePort((int)0));
        Assert.assertEquals((long)1024L, (long)ServerAddress.validatePort((int)1024));
        Assert.assertTrue((boolean)ServerAddress.isValidPort((int)ServerAddress.validatePort((int)-1)));
        ServerAddress add = new ServerAddress(Schema.IGNORE);
        Assert.assertEquals((Object)Schema.IGNORE, (Object)add.getSchema());
        Assert.assertTrue((add.getPort() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"localhost", (Object)add.getHost());
        Assert.assertTrue((add.toUri().length() > 0 ? 1 : 0) != 0);
        add = new ServerAddress(Schema.HTTP, 1234);
        Assert.assertEquals((Object)Schema.HTTP, (Object)add.getSchema());
        Assert.assertEquals((long)1234L, (long)add.getPort());
        Assert.assertEquals((Object)"localhost", (Object)add.getHost());
        Assert.assertEquals((Object)"http://localhost:1234", (Object)add.toUri());
        Assert.assertEquals((Object)"http://localhost:1234", (Object)add.toServerUri());
        add = new ServerAddress(Schema.HTTP, null, 1235);
        Assert.assertEquals((Object)Schema.HTTP, (Object)add.getSchema());
        Assert.assertEquals((long)1235L, (long)add.getPort());
        Assert.assertEquals((Object)"localhost", (Object)add.getHost());
        Assert.assertEquals((Object)"http://localhost:1235", (Object)add.toUri());
        Assert.assertEquals((Object)"http://localhost:1235", (Object)add.toServerUri());
        ServerAddress add1 = new ServerAddress(Schema.HTTP, "", 1235);
        Assert.assertEquals((Object)Schema.HTTP, (Object)add1.getSchema());
        Assert.assertEquals((long)1235L, (long)add1.getPort());
        Assert.assertEquals((Object)"localhost", (Object)add1.getHost());
        Assert.assertEquals((Object)"http://localhost:1235", (Object)add1.toUri());
        Assert.assertEquals((Object)"http://localhost:1235", (Object)add1.toServerUri());
        Assert.assertEquals((Object)add, (Object)add1);
        Assert.assertEquals((long)add.hashCode(), (long)add1.hashCode());
        add = new ServerAddress(Schema.HTTP, "xxx", 1235);
        Assert.assertEquals((Object)Schema.HTTP, (Object)add.getSchema());
        Assert.assertEquals((long)1235L, (long)add.getPort());
        Assert.assertEquals((Object)"xxx", (Object)add.getHost());
        Assert.assertEquals((Object)"http://xxx:1235", (Object)add.toUri());
        Assert.assertEquals((Object)"http://xxx:1235", (Object)add.toServerUri());
    }

    @Test
    public void testEndpoint() {
        Endpoint ep = new Endpoint(Schema.HTTP, "aa");
        Assert.assertEquals((Object)Schema.HTTP, (Object)ep.getSchema());
        Assert.assertTrue((ep.getPort() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"localhost", (Object)ep.getHost());
        Assert.assertEquals((Object)"/aa", (Object)ep.getEndpoint());
        Assert.assertTrue((ep.toUri().length() > 0 ? 1 : 0) != 0);
        ep = new Endpoint(Schema.HTTP, 1234, "");
        Assert.assertEquals((Object)Schema.HTTP, (Object)ep.getSchema());
        Assert.assertEquals((long)1234L, (long)ep.getPort());
        Assert.assertEquals((Object)"localhost", (Object)ep.getHost());
        Assert.assertEquals((Object)"", (Object)ep.getEndpoint());
        Assert.assertEquals((Object)"http://localhost:1234", (Object)ep.toUri());
        Assert.assertEquals((Object)"http://localhost:1234", (Object)ep.toServerUri());
        ep = new Endpoint(Schema.HTTP, null, 1235, "rep");
        Assert.assertEquals((Object)Schema.HTTP, (Object)ep.getSchema());
        Assert.assertEquals((long)1235L, (long)ep.getPort());
        Assert.assertEquals((Object)"localhost", (Object)ep.getHost());
        Assert.assertEquals((Object)"/rep", (Object)ep.getEndpoint());
        Assert.assertEquals((Object)"http://localhost:1235/rep", (Object)ep.toUri());
        Assert.assertEquals((Object)"http://localhost:1235", (Object)ep.toServerUri());
        Endpoint ep1 = new Endpoint(Schema.HTTP, "", 1235, "/rep");
        Assert.assertEquals((Object)Schema.HTTP, (Object)ep1.getSchema());
        Assert.assertEquals((long)1235L, (long)ep1.getPort());
        Assert.assertEquals((Object)"localhost", (Object)ep1.getHost());
        Assert.assertEquals((Object)"/rep", (Object)ep1.getEndpoint());
        Assert.assertEquals((Object)"http://localhost:1235/rep", (Object)ep1.toUri());
        Assert.assertEquals((Object)"http://localhost:1235", (Object)ep1.toServerUri());
        Assert.assertEquals((Object)ep1, (Object)Endpoint.valueOf((String)ep1.toUri()));
        Assert.assertNull((Object)Endpoint.valueOf((String)"abc1"));
        Assert.assertEquals((Object)ep, (Object)ep1);
        Assert.assertEquals((long)ep.hashCode(), (long)ep1.hashCode());
        ServerAddress server = new ServerAddress(Schema.HTTP, "xxx", 1235);
        ep = new Endpoint(server, "rep");
        Assert.assertEquals((Object)Schema.HTTP, (Object)ep.getSchema());
        Assert.assertEquals((long)1235L, (long)ep.getPort());
        Assert.assertEquals((Object)"xxx", (Object)ep.getHost());
        Assert.assertEquals((Object)"/rep", (Object)ep.getEndpoint());
        Assert.assertEquals((Object)"http://xxx:1235/rep", (Object)ep.toUri());
        Assert.assertEquals((Object)"http://xxx:1235", (Object)ep.toServerUri());
    }
}

