/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.AbstractList;
import java.util.Iterator;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;
import org.springframework.util.Assert;

public class JsonPropertyAccessor
implements PropertyAccessor {
    private static final Class<?>[] SUPPORTED_CLASSES = new Class[]{String.class, ToStringFriendlyJsonNode.class, ArrayNodeAsList.class, ObjectNode.class, ArrayNode.class};
    private ObjectMapper objectMapper = new ObjectMapper();

    public void setObjectMapper(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"'objectMapper' cannot be null");
        this.objectMapper = objectMapper;
    }

    public Class<?>[] getSpecificTargetClasses() {
        return SUPPORTED_CLASSES;
    }

    public boolean canRead(EvaluationContext context, Object target, String name) throws AccessException {
        ContainerNode<?> container = this.asJson(target);
        Integer index = this.maybeIndex(name);
        if (container instanceof ArrayNode) {
            return index != null;
        }
        return index != null && container.has(index.intValue()) || container.has(name);
    }

    private ContainerNode<?> assertContainerNode(JsonNode json) throws AccessException {
        if (json instanceof ContainerNode) {
            return (ContainerNode)json;
        }
        throw new AccessException("Can not act on json that is not a ContainerNode: " + json.getClass().getSimpleName());
    }

    private ContainerNode<?> asJson(Object target) throws AccessException {
        if (target instanceof ContainerNode) {
            return (ContainerNode)target;
        }
        if (target instanceof ToStringFriendlyJsonNode) {
            ToStringFriendlyJsonNode wrapper = (ToStringFriendlyJsonNode)target;
            return this.assertContainerNode(wrapper.node);
        }
        if (target instanceof ArrayNodeAsList) {
            ArrayNodeAsList wrapper = (ArrayNodeAsList)target;
            return this.assertContainerNode((JsonNode)wrapper.node);
        }
        if (target instanceof String) {
            try {
                JsonNode json = this.objectMapper.readTree((String)target);
                return this.assertContainerNode(json);
            }
            catch (JsonProcessingException e) {
                throw new AccessException("Exception while trying to deserialize String", (Exception)((Object)e));
            }
        }
        throw new IllegalStateException("Can't happen. Check SUPPORTED_CLASSES");
    }

    private Integer maybeIndex(String name) {
        try {
            return Integer.valueOf(name);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public TypedValue read(EvaluationContext context, Object target, String name) throws AccessException {
        ContainerNode<?> container = this.asJson(target);
        Integer index = this.maybeIndex(name);
        if (index != null && container.has(index.intValue())) {
            return JsonPropertyAccessor.typedValue(container.get(index.intValue()));
        }
        return JsonPropertyAccessor.typedValue(container.get(name));
    }

    public boolean canWrite(EvaluationContext context, Object target, String name) {
        return false;
    }

    public void write(EvaluationContext context, Object target, String name, Object newValue) {
        throw new UnsupportedOperationException("Write is not supported");
    }

    private static TypedValue typedValue(JsonNode json) {
        if (json == null) {
            return TypedValue.NULL;
        }
        return new TypedValue(JsonPropertyAccessor.wrap(json));
    }

    public static WrappedJsonNode<?> wrap(JsonNode json) {
        if (json == null) {
            return null;
        }
        if (json instanceof ArrayNode) {
            return new ArrayNodeAsList((ArrayNode)json);
        }
        return new ToStringFriendlyJsonNode(json);
    }

    public static class ArrayNodeAsList
    extends AbstractList<WrappedJsonNode<?>>
    implements WrappedJsonNode<ArrayNode> {
        private final ArrayNode node;

        ArrayNodeAsList(ArrayNode node) {
            this.node = node;
        }

        @Override
        public ArrayNode getTarget() {
            return this.node;
        }

        @Override
        public WrappedJsonNode<?> get(int index) {
            return JsonPropertyAccessor.wrap(this.node.get(index));
        }

        @Override
        public int size() {
            return this.node.size();
        }

        @Override
        public Iterator<WrappedJsonNode<?>> iterator() {
            return new Iterator<WrappedJsonNode<?>>(){
                private final Iterator<JsonNode> delegate;
                {
                    this.delegate = node.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.delegate.hasNext();
                }

                @Override
                public WrappedJsonNode<?> next() {
                    return JsonPropertyAccessor.wrap(this.delegate.next());
                }
            };
        }
    }

    public static class ToStringFriendlyJsonNode
    implements WrappedJsonNode<JsonNode> {
        private final JsonNode node;

        ToStringFriendlyJsonNode(JsonNode node) {
            this.node = node;
        }

        @Override
        public JsonNode getTarget() {
            return this.node;
        }

        public String toString() {
            if (this.node == null) {
                return "null";
            }
            if (this.node.isValueNode()) {
                return this.node.asText();
            }
            return this.node.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ToStringFriendlyJsonNode that = (ToStringFriendlyJsonNode)o;
            return this.node == that.node || this.node != null && this.node.equals((Object)that.node);
        }

        public int hashCode() {
            return this.node != null ? this.node.toString().hashCode() : 0;
        }
    }

    public static interface WrappedJsonNode<T extends JsonNode> {
        public T getTarget();
    }
}

