/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.function;

import java.lang.reflect.Field;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.stream.binder.PartitionHandler;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.util.ReflectionUtils;

class PartitionAwareFunctionWrapper
implements Function<Object, Object>,
Supplier<Object> {
    protected final Log logger = LogFactory.getLog(PartitionAwareFunctionWrapper.class);
    private final SimpleFunctionRegistry.FunctionInvocationWrapper function;
    private final Field enhancerFiled;
    private final Function<Object, Message> outputMessageEnricher;

    PartitionAwareFunctionWrapper(SimpleFunctionRegistry.FunctionInvocationWrapper function, ConfigurableApplicationContext context, ProducerProperties producerProperties) {
        this.function = function;
        this.enhancerFiled = ReflectionUtils.findField(SimpleFunctionRegistry.FunctionInvocationWrapper.class, (String)"enhancer");
        this.enhancerFiled.setAccessible(true);
        if (producerProperties != null && producerProperties.isPartitioned()) {
            StandardEvaluationContext evaluationContext = ExpressionUtils.createStandardEvaluationContext((BeanFactory)context.getBeanFactory());
            PartitionHandler partitionHandler = new PartitionHandler((EvaluationContext)evaluationContext, producerProperties, context.getBeanFactory());
            this.outputMessageEnricher = output -> {
                if (!(output instanceof Message)) {
                    output = MessageBuilder.withPayload((Object)output).build();
                }
                int partitionId = partitionHandler.determinePartition((Message)output);
                return MessageBuilder.fromMessage((Message)((Message)output)).setHeader("scst_partition", (Object)partitionId).build();
            };
        } else {
            this.outputMessageEnricher = null;
        }
    }

    @Override
    public Object apply(Object input) {
        this.setEnhancerIfNecessary();
        return this.function.apply(input);
    }

    @Override
    public Object get() {
        this.setEnhancerIfNecessary();
        return this.function.get();
    }

    private void setEnhancerIfNecessary() {
        try {
            this.enhancerFiled.set(this.function, this.outputMessageEnricher);
        }
        catch (Exception e) {
            this.logger.warn((Object)"Failed to set the enhancer", (Throwable)e);
        }
    }
}

