/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.catalog;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.core.convert.ConversionService;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuple3;
import reactor.util.function.Tuple4;
import reactor.util.function.Tuple5;
import reactor.util.function.Tuple6;
import reactor.util.function.Tuple7;
import reactor.util.function.Tuple8;
import reactor.util.function.Tuples;

class FunctionTypeConversionHelper {
    private static Log logger = LogFactory.getLog(FunctionTypeConversionHelper.class);
    private final FunctionRegistration<?> functionRegistration;
    private final Type[] functionArgumentTypes;
    private final ConversionService conversionService;
    private final MessageConverter messageConverter;

    FunctionTypeConversionHelper(FunctionRegistration<?> functionRegistration, ConversionService conversionService, MessageConverter messageConverter) {
        this.conversionService = conversionService;
        this.messageConverter = messageConverter;
        this.functionRegistration = functionRegistration;
        this.functionArgumentTypes = this.functionRegistration.getType().getType() instanceof ParameterizedType ? ((ParameterizedType)this.functionRegistration.getType().getType()).getActualTypeArguments() : new Type[]{this.functionRegistration.getType().getInputType()};
    }

    Object convertInputIfNecessary(Object input) {
        ArrayList<Object> convertedResults = new ArrayList<Object>();
        if (input instanceof Tuple2) {
            convertedResults.add(this.doConvert(((Tuple2)input).getT1(), this.getInputArgumentType(0)));
            convertedResults.add(this.doConvert(((Tuple2)input).getT2(), this.getInputArgumentType(1)));
        }
        if (input instanceof Tuple3) {
            convertedResults.add(this.doConvert(((Tuple3)input).getT3(), this.getInputArgumentType(2)));
        }
        if (input instanceof Tuple4) {
            convertedResults.add(this.doConvert(((Tuple4)input).getT4(), this.getInputArgumentType(3)));
        }
        if (input instanceof Tuple5) {
            convertedResults.add(this.doConvert(((Tuple5)input).getT5(), this.getInputArgumentType(4)));
        }
        if (input instanceof Tuple6) {
            convertedResults.add(this.doConvert(((Tuple6)input).getT6(), this.getInputArgumentType(5)));
        }
        if (input instanceof Tuple7) {
            convertedResults.add(this.doConvert(((Tuple7)input).getT7(), this.getInputArgumentType(6)));
        }
        if (input instanceof Tuple8) {
            convertedResults.add(this.doConvert(((Tuple8)input).getT8(), this.getInputArgumentType(7)));
        }
        input = CollectionUtils.isEmpty(convertedResults) ? this.doConvert(input, this.getInputArgumentType(0)) : Tuples.fromArray((Object[])convertedResults.toArray());
        return input;
    }

    Object convertOutputIfNecessary(Object output, MimeType ... acceptedOutputTypes) {
        if (ObjectUtils.isEmpty((Object[])acceptedOutputTypes)) {
            return output;
        }
        ArrayList<Object> convertedResults = new ArrayList<Object>();
        if (output instanceof Tuple2) {
            convertedResults.add(this.doConvert(((Tuple2)output).getT1(), acceptedOutputTypes[0]));
            convertedResults.add(this.doConvert(((Tuple2)output).getT2(), acceptedOutputTypes[1]));
        }
        if (output instanceof Tuple3) {
            convertedResults.add(this.doConvert(((Tuple3)output).getT3(), acceptedOutputTypes[2]));
        }
        if (output instanceof Tuple4) {
            convertedResults.add(this.doConvert(((Tuple4)output).getT4(), acceptedOutputTypes[3]));
        }
        if (output instanceof Tuple5) {
            convertedResults.add(this.doConvert(((Tuple5)output).getT5(), acceptedOutputTypes[4]));
        }
        if (output instanceof Tuple6) {
            convertedResults.add(this.doConvert(((Tuple6)output).getT6(), acceptedOutputTypes[5]));
        }
        if (output instanceof Tuple7) {
            convertedResults.add(this.doConvert(((Tuple7)output).getT7(), acceptedOutputTypes[6]));
        }
        if (output instanceof Tuple8) {
            convertedResults.add(this.doConvert(((Tuple8)output).getT8(), acceptedOutputTypes[7]));
        }
        output = Tuples.fromArray((Object[])convertedResults.toArray());
        return output;
    }

    int getInputArgumentCount() {
        Type[] types = ((ParameterizedType)this.functionArgumentTypes[0]).getActualTypeArguments();
        return types.length;
    }

    Object getInputArgument(int index) {
        return 0;
    }

    Class<?> getInputArgumentRawType(int index) {
        Type[] types = ((ParameterizedType)this.functionArgumentTypes[0]).getActualTypeArguments();
        return (Class)((ParameterizedType)types[index]).getRawType();
    }

    Type getInputArgumentType(int index) {
        if (this.functionArgumentTypes[0] instanceof ParameterizedType && (Publisher.class.isAssignableFrom((Class)((ParameterizedType)this.functionArgumentTypes[0]).getRawType()) || ((ParameterizedType)this.functionArgumentTypes[0]).getTypeName().startsWith("reactor.util.function.Tuple"))) {
            Type[] types = ((ParameterizedType)this.functionArgumentTypes[0]).getActualTypeArguments();
            return types[index];
        }
        return this.functionArgumentTypes[0];
    }

    Type getOutputArgumentType(int index) {
        if (this.functionArgumentTypes[1] instanceof ParameterizedType) {
            Type[] types = ((ParameterizedType)this.functionArgumentTypes[1]).getActualTypeArguments();
            return types[index];
        }
        return this.functionArgumentTypes[1];
    }

    private Class<?> getRawType(Type targetType) {
        Class rawType;
        if (targetType instanceof ParameterizedType) {
            if (Publisher.class.isAssignableFrom((Class)((ParameterizedType)targetType).getRawType()) || Message.class.isAssignableFrom((Class)((ParameterizedType)targetType).getRawType())) {
                if (((ParameterizedType)targetType).getActualTypeArguments()[0] instanceof ParameterizedType) {
                    return this.getRawType(((ParameterizedType)targetType).getActualTypeArguments()[0]);
                }
                rawType = (Class)((ParameterizedType)targetType).getActualTypeArguments()[0];
            } else {
                rawType = (Class)((ParameterizedType)targetType).getRawType();
            }
        } else {
            rawType = targetType instanceof WildcardType ? Object.class : (Class)targetType;
        }
        return rawType;
    }

    private Object doConvert(Object incoming, Type targetType) {
        Class<Void> actualType = this.getRawType(targetType);
        if (incoming instanceof Publisher) {
            if (!actualType.isAssignableFrom(Void.class)) {
                incoming = incoming instanceof Mono ? Mono.from((Publisher)((Publisher)incoming)).map(value -> this.doConvertArgument(value, targetType, actualType)).doOnError(System.out::println) : Flux.from((Publisher)((Publisher)incoming)).map(value -> this.doConvertArgument(value, targetType, actualType)).doOnError(System.out::println);
            }
        } else {
            Assert.isTrue((!Publisher.class.isAssignableFrom(this.functionRegistration.getType().getInputWrapper()) ? 1 : 0) != 0, (String)("Invoking reactive function as imperative is not allowed. Function name(s): " + this.functionRegistration.getNames()));
            incoming = this.doConvertArgument(incoming, targetType, actualType);
        }
        return incoming;
    }

    private Object doConvert(Object incoming, MimeType mimeType) {
        MessageHeaders headers = new MessageHeaders(Collections.singletonMap("contentType", mimeType));
        if (incoming instanceof Publisher) {
            incoming = incoming instanceof Mono ? Mono.from((Publisher)((Publisher)incoming)).map(value -> this.messageConverter.toMessage(value, headers)) : Flux.from((Publisher)((Publisher)incoming)).map(value -> this.messageConverter.toMessage(value, headers));
        } else {
            Assert.isTrue((!Publisher.class.isAssignableFrom(this.functionRegistration.getType().getInputWrapper()) ? 1 : 0) != 0, (String)("Invoking reactive function as imperative is not allowed. Function name(s): " + this.functionRegistration.getNames()));
            incoming = this.messageConverter.toMessage(incoming, headers);
        }
        return incoming;
    }

    private Object doConvertArgument(Object incomingValue, Type targetType, Class<?> actualInputType) {
        if (!Void.class.isAssignableFrom(actualInputType)) {
            if (incomingValue instanceof Message) {
                incomingValue = this.isMessage(targetType) ? this.fromMessageToMessage((Message)incomingValue, actualInputType) : this.fromMessageToValue((Message)incomingValue, actualInputType);
            } else if (!incomingValue.getClass().isAssignableFrom(actualInputType)) {
                Assert.isTrue((boolean)this.conversionService.canConvert(incomingValue.getClass(), actualInputType), (String)("Failed to convert value of type " + incomingValue.getClass() + " to " + targetType));
                incomingValue = this.conversionService.convert(incomingValue, actualInputType);
            }
        } else {
            incomingValue = null;
        }
        return incomingValue;
    }

    private boolean isMessage(Type targetType) {
        if (targetType instanceof ParameterizedType) {
            return Message.class.isAssignableFrom((Class)((ParameterizedType)targetType).getRawType());
        }
        return false;
    }

    private Object fromMessageToValue(Message<?> incomingMessage, Class<?> targetType) {
        Object incomingValue = incomingMessage.getPayload();
        if (!incomingValue.getClass().isAssignableFrom(targetType)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Converting message '" + incomingMessage + "' with payload of type '" + incomingMessage.getPayload().getClass().getName() + "' to value of type '" + targetType.getName() + "' for invocation of " + this.functionRegistration.getNames()));
            }
            incomingValue = incomingMessage.getPayload() instanceof Optional && !((Optional)incomingMessage.getPayload()).isPresent() ? incomingMessage : this.messageConverter.fromMessage(incomingMessage, targetType);
        }
        return incomingValue;
    }

    private Message<?> fromMessageToMessage(Message<?> incomingMessage, Class<?> targetType) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Converting message '" + incomingMessage + "' with payload of type '" + incomingMessage.getPayload().getClass().getName() + "' to message with payload of type '" + targetType.getName() + "' for invocation of " + this.functionRegistration.getNames()));
        }
        return MessageBuilder.withPayload((Object)this.fromMessageToValue(incomingMessage, targetType)).copyHeaders((Map)incomingMessage.getHeaders()).build();
    }
}

