/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.message;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.cloud.function.core.FluxWrapper;
import org.springframework.cloud.function.core.Isolated;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public abstract class MessageUtils {
    public static String MESSAGE_TYPE = "message-type";
    public static String TARGET_PROTOCOL = "target-protocol";

    public static Object create(Object handler, Object payload, Map<String, Object> headers) {
        if (handler instanceof FluxWrapper) {
            handler = ((FluxWrapper)handler).getTarget();
        }
        if (payload instanceof Message) {
            headers = new HashMap<String, Object>(headers);
            headers.putAll((Map<String, Object>)((Message)payload).getHeaders());
            payload = ((Message)payload).getPayload();
        }
        if (!(handler instanceof Isolated)) {
            return MessageBuilder.withPayload((Object)payload).copyHeaders(headers).build();
        }
        ClassLoader classLoader = ((Isolated)handler).getClassLoader();
        Class builder = ClassUtils.resolveClassName((String)MessageBuilder.class.getName(), (ClassLoader)classLoader);
        Method withPayload = ClassUtils.getMethod((Class)builder, (String)"withPayload", (Class[])new Class[]{Object.class});
        Method copyHeaders = ClassUtils.getMethod((Class)builder, (String)"copyHeaders", (Class[])new Class[]{Map.class});
        Method build = ClassUtils.getMethod((Class)builder, (String)"build", (Class[])new Class[0]);
        Object instance = ReflectionUtils.invokeMethod((Method)withPayload, null, (Object[])new Object[]{payload});
        ReflectionUtils.invokeMethod((Method)copyHeaders, (Object)instance, (Object[])new Object[]{headers});
        return ReflectionUtils.invokeMethod((Method)build, (Object)instance);
    }

    public static Message<?> unpack(Object handler, Object message) {
        Map headers;
        Object payload;
        Class type;
        if (handler instanceof FluxWrapper) {
            handler = ((FluxWrapper)handler).getTarget();
        }
        if (!(handler instanceof Isolated)) {
            if (message instanceof Message) {
                return (Message)message;
            }
            return MessageBuilder.withPayload((Object)message).build();
        }
        ClassLoader classLoader = ((Isolated)handler).getClassLoader();
        Class clazz = type = ClassUtils.isPresent((String)Message.class.getName(), (ClassLoader)classLoader) ? ClassUtils.resolveClassName((String)Message.class.getName(), (ClassLoader)classLoader) : null;
        if (type != null && type.isAssignableFrom(message.getClass())) {
            Map map;
            Method getPayload = ClassUtils.getMethod((Class)type, (String)"getPayload", (Class[])new Class[0]);
            Method getHeaders = ClassUtils.getMethod((Class)type, (String)"getHeaders", (Class[])new Class[0]);
            payload = ReflectionUtils.invokeMethod((Method)getPayload, (Object)message);
            headers = map = (Map)ReflectionUtils.invokeMethod((Method)getHeaders, (Object)message);
        } else {
            payload = message;
            headers = Collections.emptyMap();
        }
        return MessageBuilder.withPayload((Object)payload).copyHeaders(headers).build();
    }
}

