/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.spring;

import de.iip_ecosphere.platform.transport.spring.RegistrationHelper;
import de.iip_ecosphere.platform.transport.spring.SerializerConfiguration;
import de.iip_ecosphere.platform.transport.spring.TransportFactoryConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
@EnableConfigurationProperties(value={SerializerConfiguration.class, TransportFactoryConfiguration.class})
public class StartupApplicationListener
implements ApplicationListener<ContextRefreshedEvent> {
    @Autowired
    private SerializerConfiguration cfg;
    @Autowired
    private TransportFactoryConfiguration transportCfg;
    private boolean done = false;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (!this.done) {
            RegistrationHelper.registerSerializers(this.cfg);
            RegistrationHelper.configureTransportFactory(this.transportCfg);
            this.done = true;
        }
    }
}

