/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.spring.binder.hivemqv3;

import de.iip_ecosphere.platform.transport.spring.binder.hivemqv3.HivemqV3Client;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;

public class HivemqV3MessageProducer
extends MessageProducerSupport {
    private final ConsumerDestination destination;
    private HivemqV3Client client;

    public HivemqV3MessageProducer(ConsumerDestination destination, HivemqV3Client client) {
        this.destination = destination;
        this.client = client;
    }

    public void doStart() {
        this.client.subscribeTo(this.destination.getName(), new Callback());
    }

    protected void doStop() {
        this.client.unsubscribeFrom(this.destination.getName());
    }

    private class Callback
    implements HivemqV3Client.ArrivedCallback {
        private Callback() {
        }

        @Override
        public void messageArrived(String topic, byte[] payload) {
            Message msg = MessageBuilder.withPayload((Object)payload).build();
            HivemqV3MessageProducer.this.sendMessage(msg);
        }
    }
}

