/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.context.catalog;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.BeanFactoryAnnotationUtils;
import org.springframework.cloud.function.context.FunctionRegistration;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.function.core.FunctionInvocationHelper;
import org.springframework.cloud.function.json.JsonMapper;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.util.StringUtils;

public class BeanFactoryAwareFunctionRegistry
extends SimpleFunctionRegistry
implements ApplicationContextAware {
    private GenericApplicationContext applicationContext;

    public BeanFactoryAwareFunctionRegistry(ConversionService conversionService, CompositeMessageConverter messageConverter, JsonMapper jsonMapper, @Nullable FunctionInvocationHelper<Message<?>> functionInvocationHelper) {
        super(conversionService, messageConverter, jsonMapper, functionInvocationHelper);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (GenericApplicationContext)applicationContext;
    }

    @Override
    public int size() {
        return this.applicationContext.getBeanNamesForType(Supplier.class).length + this.applicationContext.getBeanNamesForType(Function.class).length + this.applicationContext.getBeanNamesForType(Consumer.class).length + super.size();
    }

    @Override
    public Set<String> getNames(Class<?> type) {
        Set<String> registeredNames = super.getNames(type);
        if (type == null) {
            registeredNames.addAll(Arrays.asList(this.applicationContext.getBeanNamesForType(Function.class)));
            registeredNames.addAll(Arrays.asList(this.applicationContext.getBeanNamesForType(Supplier.class)));
            registeredNames.addAll(Arrays.asList(this.applicationContext.getBeanNamesForType(Consumer.class)));
        } else {
            registeredNames.addAll(Arrays.asList(this.applicationContext.getBeanNamesForType(type)));
        }
        return registeredNames;
    }

    @Override
    public <T> T lookup(Class<?> type, String functionDefinition, String ... expectedOutputMimeTypes) {
        functionDefinition = StringUtils.hasText((String)functionDefinition) ? functionDefinition : this.applicationContext.getEnvironment().getProperty("spring.cloud.function.definition", "");
        if (!StringUtils.hasText((String)(functionDefinition = this.normalizeFunctionDefinition(functionDefinition)))) {
            this.logger.info((Object)"Can't determine default function definition. Please use 'spring.cloud.function.definition' property to explicitly define it.");
            return null;
        }
        SimpleFunctionRegistry.FunctionInvocationWrapper function = (SimpleFunctionRegistry.FunctionInvocationWrapper)this.doLookup(type, functionDefinition, expectedOutputMimeTypes);
        if (function == null) {
            String[] functionNames;
            Set<String> functionRegistratioinNames = super.getNames(null);
            for (String functionName : functionNames = StringUtils.delimitedListToStringArray((String)functionDefinition.replaceAll(",", "|").trim(), (String)"|")) {
                if (functionRegistratioinNames.contains(functionName) && this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Skipping function '" + functionName + "' since it is already present"));
                    continue;
                }
                Object functionCandidate = this.discoverFunctionInBeanFactory(functionName);
                if (functionCandidate != null) {
                    Type functionType = null;
                    FunctionRegistration functionRegistration = null;
                    if (functionCandidate instanceof FunctionRegistration) {
                        functionRegistration = (FunctionRegistration)functionCandidate;
                    } else if (this.isFunctionPojo(functionCandidate, functionName)) {
                        Method functionalMethod = FunctionTypeUtils.discoverFunctionalMethod(functionCandidate.getClass());
                        functionCandidate = this.proxyTarget(functionCandidate, functionalMethod);
                        functionType = FunctionTypeUtils.fromFunctionMethod(functionalMethod);
                    } else if (this.isSpecialFunctionRegistration(functionNames, functionName)) {
                        functionRegistration = (FunctionRegistration)this.applicationContext.getBean(functionName + FunctionRegistration.REGISTRATION_NAME_SUFFIX, FunctionRegistration.class);
                    } else {
                        functionType = FunctionTypeUtils.discoverFunctionType(functionCandidate, functionName, this.applicationContext);
                    }
                    if (functionRegistration == null) {
                        functionRegistration = new FunctionRegistration<Object>(functionCandidate, functionName).type(functionType);
                    }
                    this.register(functionRegistration);
                    continue;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Function '" + functionName + "' is not available in FunctionCatalog or BeanFactory"));
            }
            function = (SimpleFunctionRegistry.FunctionInvocationWrapper)super.doLookup(type, functionDefinition, expectedOutputMimeTypes);
        }
        return (T)function;
    }

    private Object discoverFunctionInBeanFactory(String functionName) {
        Object functionCandidate = null;
        if (this.applicationContext.containsBean(functionName)) {
            functionCandidate = this.applicationContext.getBean(functionName);
        } else {
            try {
                functionCandidate = BeanFactoryAnnotationUtils.qualifiedBeanOfType((BeanFactory)this.applicationContext.getBeanFactory(), Object.class, (String)functionName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return functionCandidate;
    }

    @Override
    protected boolean containsFunction(String functionName) {
        return super.containsFunction(functionName) ? true : this.applicationContext.containsBean(functionName);
    }

    private boolean isFunctionPojo(Object functionCandidate, String functionName) {
        return !functionCandidate.getClass().isSynthetic() && !(functionCandidate instanceof Supplier) && !(functionCandidate instanceof Function) && !(functionCandidate instanceof Consumer) && !this.applicationContext.containsBean(functionName + FunctionRegistration.REGISTRATION_NAME_SUFFIX);
    }

    private boolean isSpecialFunctionRegistration(Object functionCandidate, String functionName) {
        return this.applicationContext.containsBean(functionName + FunctionRegistration.REGISTRATION_NAME_SUFFIX);
    }

    private Object proxyTarget(Object targetFunction, final Method actualMethodToCall) {
        ProxyFactory pf = new ProxyFactory(targetFunction);
        pf.setProxyTargetClass(true);
        pf.setInterfaces(new Class[]{Function.class});
        pf.addAdvice((Advice)new MethodInterceptor(){

            public Object invoke(MethodInvocation invocation) throws Throwable {
                return actualMethodToCall.invoke(invocation.getThis(), invocation.getArguments());
            }
        });
        return pf.getProxy();
    }
}

