/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.spring;

import de.iip_ecosphere.platform.support.identities.IdentityStore;
import de.iip_ecosphere.platform.support.net.SslUtils;
import de.iip_ecosphere.platform.transport.connectors.TransportParameter;
import java.io.IOException;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class BasicConfiguration {
    private String host;
    private int port;
    private String keystoreKey;
    private String keyAlias;
    private boolean hostnameVerification = false;
    private String authenticationKey;

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getKeystoreKey() {
        return this.keystoreKey;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public boolean getHostnameVerification() {
        return this.hostnameVerification;
    }

    public String getAuthenticationKey() {
        return this.authenticationKey;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setKeystoreKey(String keystoreKey) {
        this.keystoreKey = keystoreKey;
    }

    public void setKeyAlias(String alias) {
        this.keyAlias = alias;
    }

    public void setHostnameVerification(boolean hostnameVerification) {
        this.hostnameVerification = hostnameVerification;
    }

    public void setAuthenticationKey(String authenticationKey) {
        this.authenticationKey = authenticationKey;
    }

    public TransportParameter toTransportParameter() {
        return this.createTransportParameterBuilder().build();
    }

    protected TransportParameter.TransportParameterBuilder createTransportParameterBuilder() {
        TransportParameter.TransportParameterBuilder builder = TransportParameter.TransportParameterBuilder.newBuilder((String)this.getHost(), (int)this.getPort());
        builder.setKeystoreKey(this.getKeystoreKey());
        if (this.useTls()) {
            if (null != this.getKeyAlias()) {
                builder.setKeyAlias(this.getKeyAlias());
            }
            builder.setHostnameVerification(this.getHostnameVerification());
        }
        return builder;
    }

    public boolean useTls() {
        return null != this.getKeystoreKey();
    }

    public TrustManagerFactory createTrustManagerFactory() throws IOException {
        return SslUtils.createTrustManagerFactory((KeyStore)IdentityStore.getInstance().getKeystoreFile(this.getKeystoreKey(), new String[0]));
    }

    public SSLContext createTlsContext() throws IOException {
        return IdentityStore.getInstance().createTlsContext(this.getKeystoreKey(), this.getKeyAlias(), new String[0]);
    }
}

