/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.integration.channel.interceptor.GlobalChannelInterceptorWrapper;
import org.springframework.integration.config.GlobalChannelInterceptor;
import org.springframework.integration.config.IntegrationConfigurationInitializer;
import org.springframework.util.CollectionUtils;

public class GlobalChannelInterceptorInitializer
implements IntegrationConfigurationInitializer {
    @Override
    public void initialize(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        for (String beanName : registry.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = registry.getBeanDefinition(beanName);
            if (!(beanDefinition instanceof AnnotatedBeanDefinition)) continue;
            AnnotationMetadata metadata = ((AnnotatedBeanDefinition)beanDefinition).getMetadata();
            Map annotationAttributes = metadata.getAnnotationAttributes(GlobalChannelInterceptor.class.getName());
            if (CollectionUtils.isEmpty((Map)annotationAttributes) && beanDefinition.getSource() instanceof MethodMetadata) {
                MethodMetadata beanMethod = (MethodMetadata)beanDefinition.getSource();
                annotationAttributes = beanMethod.getAnnotationAttributes(GlobalChannelInterceptor.class.getName());
            }
            if (CollectionUtils.isEmpty((Map)annotationAttributes)) continue;
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(GlobalChannelInterceptorWrapper.class).addConstructorArgReference(beanName).addPropertyValue("patterns", annotationAttributes.get("patterns")).addPropertyValue("order", annotationAttributes.get("order"));
            BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)builder.getBeanDefinition(), (BeanDefinitionRegistry)registry);
        }
    }
}

