/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.function;

import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.cloud.stream.binder.PollableMessageSource;
import org.springframework.cloud.stream.binding.BindableProxyFactory;
import org.springframework.cloud.stream.binding.BoundTargetHolder;
import org.springframework.cloud.stream.function.StreamFunctionProperties;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

class BindableFunctionProxyFactory
extends BindableProxyFactory {
    private final int inputCount;
    private final int outputCount;
    private final String functionDefinition;
    private final StreamFunctionProperties functionProperties;
    private final boolean pollable;
    @Autowired
    private GenericApplicationContext context;

    BindableFunctionProxyFactory(String functionDefinition, int inputCount, int outputCount, StreamFunctionProperties functionProperties) {
        this(functionDefinition, inputCount, outputCount, functionProperties, false);
    }

    BindableFunctionProxyFactory(String functionDefinition, int inputCount, int outputCount, StreamFunctionProperties functionProperties, boolean pollable) {
        super(null);
        this.inputCount = inputCount;
        this.outputCount = outputCount;
        this.functionDefinition = functionDefinition;
        this.functionProperties = functionProperties;
        this.pollable = pollable;
    }

    @Override
    public void afterPropertiesSet() {
        int i;
        Assert.notEmpty((Map)this.bindingTargetFactories, (String)"'bindingTargetFactories' cannot be empty");
        if (this.inputCount > 0) {
            for (i = 0; i < this.inputCount; ++i) {
                this.createInput(this.buildInputNameForIndex(i));
            }
        }
        if (this.outputCount > 0) {
            for (i = 0; i < this.outputCount; ++i) {
                this.createOutput(this.buildOutputNameForIndex(i));
            }
        }
    }

    @Override
    public Class<?> getObjectType() {
        return this.type;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    protected String getFunctionDefinition() {
        return this.functionDefinition;
    }

    protected String getInputName(int index) {
        return CollectionUtils.isEmpty(this.getInputs()) ? null : this.getInputs().toArray(new String[0])[index];
    }

    protected String getOutputName(int index) {
        String outputName = null;
        if (this.outputCount > 0) {
            outputName = CollectionUtils.isEmpty(this.getOutputs()) ? null : this.getOutputs().toArray(new String[0])[index];
        }
        return outputName;
    }

    protected boolean isMultiple() {
        return this.inputCount > 1 || this.outputCount > 1;
    }

    private String buildInputNameForIndex(int index) {
        return this.functionDefinition.replace(",", "|").replace("|", "") + "-" + "in" + "-" + index;
    }

    private String buildOutputNameForIndex(int index) {
        return this.functionDefinition.replace(",", "|").replace("|", "") + "-" + "out" + "-" + index;
    }

    private void createInput(String name) {
        if (this.functionProperties.getBindings().containsKey(name)) {
            name = this.functionProperties.getBindings().get(name);
        }
        if (this.pollable) {
            PollableMessageSource pollableSource = (PollableMessageSource)this.getBindingTargetFactory(PollableMessageSource.class).createInput(name);
            if (this.context != null && !this.context.containsBean(name)) {
                this.context.registerBean(name, PollableMessageSource.class, () -> pollableSource, new BeanDefinitionCustomizer[0]);
            }
            this.inputHolders.put(name, new BoundTargetHolder(pollableSource, true));
        } else {
            this.inputHolders.put(name, new BoundTargetHolder(this.getBindingTargetFactory(SubscribableChannel.class).createInput(name), true));
        }
    }

    private void createOutput(String name) {
        if (this.functionProperties.getBindings().containsKey(name)) {
            name = this.functionProperties.getBindings().get(name);
        }
        this.outputHolders.put(name, new BoundTargetHolder(this.getBindingTargetFactory(MessageChannel.class).createOutput(name), true));
    }
}

