/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.spring;

import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.TransportFactory;
import de.iip_ecosphere.platform.transport.connectors.TransportConnector;
import de.iip_ecosphere.platform.transport.serialization.Serializer;
import de.iip_ecosphere.platform.transport.serialization.SerializerRegistry;
import de.iip_ecosphere.platform.transport.spring.SerializerConfiguration;
import de.iip_ecosphere.platform.transport.spring.TransportFactoryConfiguration;
import java.lang.reflect.InvocationTargetException;
import org.springframework.lang.Nullable;

public class RegistrationHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegistrationHelper.class);

    public static void registerSerializers(SerializerConfiguration cfg) {
        for (String s : cfg.getSerializers()) {
            Serializer ser = RegistrationHelper.obtainInstance(s, "Serializer registration", Serializer.class);
            if (null == ser) continue;
            SerializerRegistry.registerSerializer((Serializer)ser);
            LOGGER.info("Registered Serializer " + s);
        }
        SerializerRegistry.setName((String)cfg.getName());
    }

    public static void configureTransportFactory(TransportFactoryConfiguration cfg) {
        TransportFactory.ConnectorCreator cr = RegistrationHelper.obtainConnectorCreator(cfg.getMainTransportClassName(), "Configuring main transport connector");
        if (null != cr) {
            TransportFactory.setMainImplementation((TransportFactory.ConnectorCreator)cr);
            LOGGER.error("Registered main transport connector " + cfg.getMainTransportClassName());
        }
        if (null != (cr = RegistrationHelper.obtainConnectorCreator(cfg.getDirectMemoryClassName(), "Configuring direct memory transport connector"))) {
            TransportFactory.setDmImplementation((TransportFactory.ConnectorCreator)cr);
            LOGGER.error("Registered direct-memory transport connector " + cfg.getDirectMemoryClassName());
        }
        if (null != (cr = RegistrationHelper.obtainConnectorCreator(cfg.getInterProcessClassName(), "Configuring inter-process transport connector"))) {
            TransportFactory.setIpcImplementation((TransportFactory.ConnectorCreator)cr);
            LOGGER.error("Registered inter-process transport connector " + cfg.getInterProcessClassName());
        }
    }

    @Nullable
    private static TransportFactory.ConnectorCreator obtainConnectorCreator(String className, String context) {
        TransportConnector conn;
        TransportFactory.ConnectorCreator result = null;
        if (className.length() > 0 && null != (conn = RegistrationHelper.obtainInstance(className, context, TransportConnector.class))) {
            final Class cls = conn.getClass();
            final String name = conn.getName();
            result = new TransportFactory.ConnectorCreator(){

                public TransportConnector createConnector() {
                    TransportConnector result;
                    try {
                        result = (TransportConnector)cls.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        result = null;
                    }
                    return result;
                }

                public String getName() {
                    return name;
                }
            };
        }
        return result;
    }

    public static <T> T obtainInstance(String className, String context, Class<? extends T> type) {
        T result;
        try {
            result = type.cast(Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            result = null;
            LOGGER.error(context + ": class " + className + " cannot be created: " + e.getClass().getName() + " " + e.getMessage());
        }
        return result;
    }
}

