/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.transport;

import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import de.iip_ecosphere.platform.transport.status.ActionType;
import de.iip_ecosphere.platform.transport.status.ActionTypes;
import de.iip_ecosphere.platform.transport.status.StatusMessage;
import de.iip_ecosphere.platform.transport.status.TraceRecord;
import de.iip_ecosphere.platform.transport.status.TraceRecordSerializer;
import java.io.IOException;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.transport.TraceRecordTestFilter;

public class TraceRecordTest {
    @Test
    public void testTraceRecord() throws IOException {
        StatusMessage payload = new StatusMessage((ActionType)ActionTypes.ADDED, "1234", new String[]{"abba"});
        TraceRecord record = new TraceRecord("src", "act", (Object)payload);
        TraceRecordSerializer ser = new TraceRecordSerializer();
        byte[] s = ser.to(record);
        TraceRecord tr = ser.from(s);
        Assert.assertNotNull((Object)tr);
        Assert.assertEquals((Object)record.getAction(), (Object)tr.getAction());
        Assert.assertEquals((Object)record.getSource(), (Object)tr.getSource());
        Assert.assertEquals((long)record.getTimestamp(), (long)tr.getTimestamp());
        Assert.assertNotNull((Object)record.getPayload());
        Assert.assertTrue((boolean)(record.getPayload() instanceof StatusMessage));
        StatusMessage p = (StatusMessage)record.getPayload();
        Assert.assertEquals((Object)payload.getAction(), (Object)p.getAction());
        Assert.assertEquals((Object)payload.getId(), (Object)p.getId());
        Assert.assertArrayEquals((Object[])payload.getAliasIds(), (Object[])p.getAliasIds());
    }

    @Test
    public void testTraceRecordFiltering() throws IOException {
        Assert.assertTrue((boolean)(TraceRecordSerializer.getFilter() instanceof TraceRecordTestFilter));
        TraceRecordTestFilter testFilter = (TraceRecordTestFilter)TraceRecordSerializer.getFilter();
        Assert.assertTrue((testFilter.getCountInitializeCalls() > 0 ? 1 : 0) != 0);
        testFilter.clear();
        Payload pl = new Payload();
        pl.setField(25);
        pl.setInner(new InnerPayload());
        TraceRecord record = new TraceRecord("src", "act", (Object)pl);
        TraceRecordSerializer ser = new TraceRecordSerializer();
        TraceRecord.ignoreClass(InnerPayload.class);
        TraceRecord record2 = ser.from(ser.to(record));
        HashMap payload = (HashMap)record2.getPayload();
        Assert.assertNotNull(payload.get("field"));
        Assert.assertEquals((Object)25, payload.get("field"));
        Assert.assertNull(payload.get("inner"));
        TraceRecordSerializer.clearIgnores();
        TraceRecord.ignoreField(Payload.class, (String)"field");
        record2 = ser.from(ser.to(record));
        payload = (HashMap)record2.getPayload();
        Assert.assertNull(payload.get("field"));
        Assert.assertNotNull(payload.get("inner"));
        TraceRecordSerializer.clearIgnores();
        TraceRecord.ignoreFields(Payload.class, (String[])new String[]{"field"});
        record2 = ser.from(ser.to(record));
        payload = (HashMap)record2.getPayload();
        Assert.assertNull(payload.get("field"));
        Assert.assertNotNull(payload.get("inner"));
        TraceRecordSerializer.clearIgnores();
        Assert.assertTrue((testFilter.getCountFilterCalls() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testTraceRecordJson() throws IOException {
        Payload pl = new Payload();
        pl.setField(25);
        pl.setInner(new InnerPayload());
        TraceRecord record = new TraceRecord("src", "act", (Object)pl);
        TypeTranslator tt = TraceRecordSerializer.createTypeTranslator();
        tt.from((Object)((String)tt.to((Object)record)));
        record = new TraceRecord("src", "act", null);
        tt.from((Object)((String)tt.to((Object)record)));
    }

    public class Payload {
        private int field;
        private InnerPayload inner;

        public int getField() {
            return this.field;
        }

        public void setField(int field) {
            this.field = field;
        }

        public InnerPayload getInner() {
            return this.inner;
        }

        public void setInner(InnerPayload inner) {
            this.inner = inner;
        }
    }

    public class InnerPayload {
    }
}

