/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.transport;

import de.iip_ecosphere.platform.transport.serialization.StringSerializer;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslators;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class TypeTranslatorsTest {
    @Test
    public void testString() throws IOException {
        Assert.assertEquals((Object)"", (Object)TypeTranslators.STRING.to((Object)((String)TypeTranslators.STRING.from((Object)""))));
        Assert.assertEquals((Object)"abc", (Object)TypeTranslators.STRING.to((Object)((String)TypeTranslators.STRING.from((Object)"abc"))));
    }

    @Test
    public void testInteger() throws IOException {
        int test = 1234;
        Assert.assertEquals((long)1234L, (long)((Integer)TypeTranslators.INTEGER.to((Object)((String)TypeTranslators.INTEGER.from((Object)1234)))).intValue());
        try {
            TypeTranslators.INTEGER.to((Object)"abba");
            Assert.fail((String)"No IOException thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testJsonString() throws IOException {
        String test = "a\"\b";
        Assert.assertEquals((Object)"a\"\b", (Object)TypeTranslators.JSON_STRING.to((Object)((String)TypeTranslators.JSON_STRING.from((Object)"a\"\b"))));
    }

    @Test
    public void testLong() throws IOException {
        long test = 12354058L;
        Assert.assertEquals((long)12354058L, (long)((Long)TypeTranslators.LONG.to((Object)((String)TypeTranslators.LONG.from((Object)12354058L)))));
    }

    @Test
    public void testBoolean() throws IOException {
        Assert.assertTrue((boolean)((Boolean)TypeTranslators.BOOLEAN.to((Object)((String)TypeTranslators.BOOLEAN.from((Object)true)))));
        Assert.assertFalse((boolean)((Boolean)TypeTranslators.BOOLEAN.to((Object)((String)TypeTranslators.BOOLEAN.from((Object)false)))));
    }

    @Test
    public void testDouble() throws IOException {
        double test = 12.353058;
        Assert.assertEquals((double)12.353058, (double)((Double)TypeTranslators.DOUBLE.to((Object)((String)TypeTranslators.DOUBLE.from((Object)12.353058)))), (double)0.001);
    }

    @Test
    public void testByteArrayBase64() throws IOException {
        String test = "123 BAAB\n42;";
        byte[] testArray = "123 BAAB\n42;".getBytes();
        Assert.assertArrayEquals((byte[])testArray, (byte[])((byte[])TypeTranslators.BYTEARRAY_TO_BASE64.from((Object)((String)TypeTranslators.BYTEARRAY_TO_BASE64.to((Object)testArray)))));
        Assert.assertArrayEquals((byte[])testArray, (byte[])((byte[])TypeTranslators.BASE64_TO_BYTEARRAY.to((Object)((String)TypeTranslators.BASE64_TO_BYTEARRAY.from((Object)testArray)))));
    }

    @Test
    public void testCreateTypeTranslator() {
        Assert.assertNotNull((Object)TypeTranslators.createTypeTranslator((ClassLoader)this.getClass().getClassLoader(), (String)TestTypeTranslator.class.getName()));
        Assert.assertNull((Object)TypeTranslators.createTypeTranslator((ClassLoader)this.getClass().getClassLoader(), (String)"abc.defg"));
    }

    @Test
    public void testCreateSerializer() {
        Assert.assertNotNull((Object)TypeTranslators.createSerializer((ClassLoader)this.getClass().getClassLoader(), (String)StringSerializer.class.getName()));
        Assert.assertNull((Object)TypeTranslators.createSerializer((ClassLoader)this.getClass().getClassLoader(), (String)"abc.def"));
    }

    public static class TestTypeTranslator
    implements TypeTranslator<String, String> {
        public String from(String data) throws IOException {
            return null;
        }

        public String to(String source) throws IOException {
            return null;
        }
    }
}

