/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.transport;

import de.iip_ecosphere.platform.transport.serialization.Serializer;
import java.io.IOException;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import test.de.iip_ecosphere.platform.transport.JsonUtils;
import test.de.iip_ecosphere.platform.transport.Product;

public class ProductJsonSerializer
implements Serializer<Product> {
    public byte[] to(Product value) throws IOException {
        JSONObject json = new JSONObject();
        json.put((Object)"description", (Object)value.getDescription());
        json.put((Object)"price", (Object)value.getPrice());
        return json.toJSONString().getBytes();
    }

    public Product from(byte[] data) throws IOException {
        Product result;
        try {
            JSONParser parser = new JSONParser();
            JSONObject obj = (JSONObject)parser.parse(new String(data));
            result = new Product(JsonUtils.readString(obj, "description"), JsonUtils.readDouble(obj, "price", 0.0));
        }
        catch (ParseException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (ClassCastException e) {
            throw new IOException(e.getMessage(), e);
        }
        return result;
    }

    public Product clone(Product origin) throws IOException {
        return new Product(origin.getDescription(), origin.getPrice());
    }

    public Class<Product> getType() {
        return Product.class;
    }
}

