/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import java.io.IOException;

public class GenericJsonToStringTranslator<T>
implements TypeTranslator<T, String> {
    private ObjectMapper mapper;
    private Class<T> cls;

    public GenericJsonToStringTranslator(Class<T> cls) {
        this(cls, null);
    }

    public GenericJsonToStringTranslator(Class<T> cls, ObjectMapper mapper) {
        this.cls = cls;
        if (null == mapper) {
            this.mapper = new ObjectMapper();
            JsonUtils.handleIipDataClasses((ObjectMapper)this.mapper);
        } else {
            this.mapper = mapper;
        }
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    @Override
    public T from(String data) throws IOException {
        try {
            return (T)this.mapper.readValue(data, this.cls);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public String to(T source) throws IOException {
        try {
            return this.mapper.writeValueAsString(source);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }
}

