/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.status;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.transport.serialization.GenericJsonToStringTranslator;
import de.iip_ecosphere.platform.transport.serialization.Serializer;
import de.iip_ecosphere.platform.transport.serialization.TypeTranslator;
import de.iip_ecosphere.platform.transport.status.ActionType;
import de.iip_ecosphere.platform.transport.status.ActionTypes;
import de.iip_ecosphere.platform.transport.status.ComponentType;
import de.iip_ecosphere.platform.transport.status.ComponentTypes;
import de.iip_ecosphere.platform.transport.status.StatusMessage;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class StatusMessageSerializer
implements Serializer<StatusMessage> {
    private static final Map<String, ActionType> ACTION_CONSTANTS = new HashMap<String, ActionType>();
    private static final Map<String, ComponentType> COMPONENT_CONSTANTS = new HashMap<String, ComponentType>();
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static TypeTranslator<StatusMessage, String> createTypeTranslator() {
        return new GenericJsonToStringTranslator<StatusMessage>(StatusMessage.class, MAPPER);
    }

    public static void registerActions(Class<? extends ActionType> type) {
        StatusMessageSerializer.register(type, ACTION_CONSTANTS);
    }

    public static void registerComponents(Class<? extends ComponentType> type) {
        StatusMessageSerializer.register(type, COMPONENT_CONSTANTS);
    }

    private static <T> void register(Class<? extends T> cls, Map<String, T> mapping) {
        for (Field f : cls.getDeclaredFields()) {
            int mod = f.getModifiers();
            if (!Modifier.isStatic(mod) || !Modifier.isPublic(mod) || !Modifier.isFinal(mod) || f.getType() != cls || mapping.containsKey(f.getName())) continue;
            try {
                mapping.put(f.getName(), f.get(null));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    @Override
    public StatusMessage from(byte[] data) throws IOException {
        return (StatusMessage)MAPPER.readValue(data, StatusMessage.class);
    }

    @Override
    public byte[] to(StatusMessage source) throws IOException {
        return MAPPER.writeValueAsBytes((Object)source);
    }

    @Override
    public StatusMessage clone(StatusMessage origin) throws IOException {
        return new StatusMessage(origin.getComponentType(), origin.getAction(), origin.getId(), origin.getDeviceId(), origin.getAliasIds());
    }

    @Override
    public Class<StatusMessage> getType() {
        return StatusMessage.class;
    }

    static {
        StatusMessageSerializer.registerActions(ActionTypes.class);
        StatusMessageSerializer.registerComponents(ComponentTypes.class);
        SimpleModule module = new SimpleModule();
        module.addDeserializer(ActionType.class, (JsonDeserializer)new JsonUtils.EnumDeserializer(ACTION_CONSTANTS, ActionType.class));
        module.addDeserializer(ComponentType.class, (JsonDeserializer)new JsonUtils.EnumDeserializer(COMPONENT_CONSTANTS, ComponentType.class));
        MAPPER.registerModule((Module)module);
    }
}

